/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.lifecyclemapping;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.m2e.core.internal.lifecyclemapping.DuplicateLifecycleMappingMetadataException;
import org.eclipse.m2e.core.internal.lifecyclemapping.MappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingFilter;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadata;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionMetadata;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;

public class SimpleMappingMetadataSource
implements MappingMetadataSource {
    private final List<LifecycleMappingMetadataSource> sources = new ArrayList<LifecycleMappingMetadataSource>();
    private final List<LifecycleMappingMetadata> lifecycleMappings = new ArrayList<LifecycleMappingMetadata>();
    private final List<PluginExecutionMetadata> pluginExecutions = new ArrayList<PluginExecutionMetadata>();
    private final List<LifecycleMappingFilter> mappingFilters = new ArrayList<LifecycleMappingFilter>();

    public SimpleMappingMetadataSource(LifecycleMappingMetadataSource source) {
        this.sources.add(source);
        this.lifecycleMappings.addAll(source.getLifecycleMappings());
        this.pluginExecutions.addAll(source.getPluginExecutions());
        this.mappingFilters.addAll(source.getLifecycleMappingFilters());
    }

    public SimpleMappingMetadataSource(List<LifecycleMappingMetadataSource> sources) {
        this.sources.addAll(sources);
        for (LifecycleMappingMetadataSource source : sources) {
            this.lifecycleMappings.addAll(source.getLifecycleMappings());
            this.pluginExecutions.addAll(source.getPluginExecutions());
            this.mappingFilters.addAll(source.getLifecycleMappingFilters());
        }
    }

    public SimpleMappingMetadataSource(LifecycleMappingMetadata lifecycleMapping) {
        this.pluginExecutions.addAll(lifecycleMapping.getPluginExecutions());
    }

    public List<LifecycleMappingMetadataSource> getSources() {
        return this.sources;
    }

    @Override
    public LifecycleMappingMetadata getLifecycleMappingMetadata(String packagingType, Predicate<LifecycleMappingMetadata> filter) throws DuplicateLifecycleMappingMetadataException {
        List<LifecycleMappingMetadata> matching;
        if (packagingType == null) {
            return null;
        }
        Stream<LifecycleMappingMetadata> stream = this.lifecycleMappings.stream().filter(mapping -> packagingType.equals(mapping.getPackagingType()));
        if (filter != null) {
            stream = stream.filter(Predicate.not(filter));
        }
        if ((matching = stream.toList()).isEmpty()) {
            return null;
        }
        if (matching.size() == 1) {
            return matching.get(0);
        }
        throw new DuplicateLifecycleMappingMetadataException(matching);
    }

    @Override
    public List<PluginExecutionMetadata> getPluginExecutionMetadata(MojoExecutionKey execution) {
        ArrayList<PluginExecutionMetadata> mappings = new ArrayList<PluginExecutionMetadata>();
        if (execution != null) {
            for (PluginExecutionMetadata mapping : this.pluginExecutions) {
                if (!mapping.getFilter().match(execution)) continue;
                mappings.add(mapping);
            }
        }
        return mappings;
    }

    @Override
    public List<LifecycleMappingFilter> getFilters() {
        return this.mappingFilters;
    }
}

