/*
 * Decompiled with CFR 0.152.
 */
package io.github.g00fy2.versioncompare;

import java.util.List;
import javax.annotation.Nonnull;

final class VersionComparator {
    static final int MAJOR = 0;
    static final int MINOR = 1;
    static final int PATCH = 2;
    private static final String SNAPSHOT_STRING = "snapshot";
    private static final String PRE_STRING = "pre";
    private static final String ALPHA_STRING = "alpha";
    private static final String BETA_STRING = "beta";
    private static final String RC_STRING = "rc";
    private static final int SNAPSHOT = 0;
    private static final int PRE_ALPHA = 1;
    private static final int ALPHA = 2;
    private static final int BETA = 3;
    private static final int RC = 4;
    private static final int UNKNOWN = 5;

    private VersionComparator() {
    }

    static int compareSubversionNumbers(@Nonnull List<Integer> subversionsA, @Nonnull List<Integer> subversionsB) {
        int versASize = subversionsA.size();
        int versBSize = subversionsB.size();
        int maxSize = Math.max(versASize, versBSize);
        for (int i = 0; i < maxSize; ++i) {
            if ((i < versASize ? subversionsA.get(i) : 0) > (i < versBSize ? subversionsB.get(i) : 0)) {
                return 1;
            }
            if ((i < versASize ? subversionsA.get(i) : 0) >= (i < versBSize ? subversionsB.get(i) : 0)) continue;
            return -1;
        }
        return 0;
    }

    static int compareSuffix(@Nonnull String suffixA, @Nonnull String suffixB) {
        if (suffixA.length() > 0 || suffixB.length() > 0) {
            int qualifierB;
            int qualifierA = VersionComparator.qualifierToNumber(suffixA);
            if (qualifierA > (qualifierB = VersionComparator.qualifierToNumber(suffixB))) {
                return 1;
            }
            if (qualifierA < qualifierB) {
                return -1;
            }
            if (qualifierA != 5 && qualifierA != 0) {
                int suffixVersionB;
                int suffixVersionA = VersionComparator.preReleaseVersion(suffixA, qualifierA);
                if (suffixVersionA > (suffixVersionB = VersionComparator.preReleaseVersion(suffixB, qualifierB))) {
                    return 1;
                }
                if (suffixVersionA < suffixVersionB) {
                    return -1;
                }
            }
        }
        return 0;
    }

    static int qualifierToNumber(@Nonnull String suffix) {
        if (suffix.length() > 0) {
            if ((suffix = suffix.toLowerCase()).contains(RC_STRING)) {
                return 4;
            }
            if (suffix.contains(BETA_STRING)) {
                return 3;
            }
            if (suffix.contains(ALPHA_STRING)) {
                if (suffix.substring(0, suffix.indexOf(ALPHA_STRING)).contains(PRE_STRING)) {
                    return 1;
                }
                return 2;
            }
            if (suffix.contains(SNAPSHOT_STRING)) {
                return 0;
            }
        }
        return 5;
    }

    static int preReleaseVersion(@Nonnull String suffix, int qualifier) {
        int maxStartIndex;
        int startIndex = VersionComparator.indexOfQualifier(suffix, qualifier);
        if (startIndex < suffix.length() && VersionComparator.containsNumeric(suffix.substring(startIndex, maxStartIndex = Math.min(startIndex + 2, suffix.length())))) {
            StringBuilder versionNumber = new StringBuilder();
            for (int i = startIndex; i < suffix.length(); ++i) {
                char c = suffix.charAt(i);
                if (Character.isDigit(c)) {
                    versionNumber.append(c);
                    continue;
                }
                if (i != startIndex) break;
            }
            return VersionComparator.safeParseInt(versionNumber.toString());
        }
        return 0;
    }

    private static int indexOfQualifier(@Nonnull String suffix, int qualifier) {
        if (qualifier == 4) {
            return suffix.indexOf(RC_STRING) + RC_STRING.length();
        }
        if (qualifier == 3) {
            return suffix.indexOf(BETA_STRING) + BETA_STRING.length();
        }
        if (qualifier == 2 || qualifier == 1) {
            return suffix.indexOf(ALPHA_STRING) + ALPHA_STRING.length();
        }
        return 0;
    }

    static boolean startsNumeric(@Nonnull String str) {
        return (str = str.trim()).length() > 0 && Character.isDigit(str.charAt(0));
    }

    static int safeParseInt(@Nonnull String numbers) {
        if (numbers.length() > 9) {
            numbers = numbers.substring(0, 9);
        }
        return Integer.parseInt(numbers);
    }

    static boolean isNumeric(@Nonnull CharSequence cs) {
        int sz = cs.length();
        if (sz > 0) {
            for (int i = 0; i < sz; ++i) {
                if (Character.isDigit(cs.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean containsNumeric(@Nonnull CharSequence cs) {
        int sz = cs.length();
        if (sz > 0) {
            for (int i = 0; i < sz; ++i) {
                if (!Character.isDigit(cs.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }
}

