/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac.dom;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.JavacBindingResolver;
import org.eclipse.jdt.internal.javac.dom.JavacTypeBinding;

public abstract class JavacTypeVariableBinding
extends JavacTypeBinding {
    private final Symbol.TypeVariableSymbol sym;
    private final JavacBindingResolver bindingResolver;
    private final Type.TypeVar typeVar;

    public JavacTypeVariableBinding(Type.TypeVar type, Symbol.TypeVariableSymbol sym, Symbol backupOwner, JavacBindingResolver bindingResolver) {
        super(type, sym, null, backupOwner, false, bindingResolver);
        this.typeVar = type;
        this.sym = sym;
        this.bindingResolver = bindingResolver;
    }

    @Override
    public String getKey() {
        return this.getKeyWithCaptureCode();
    }

    public String getKeyWithCaptureCode() {
        return this.getKeyWithOptionalCaptureCode(true);
    }

    public String getKeyWithoutCaptureCode() {
        return this.getKeyWithOptionalCaptureCode(false);
    }

    /*
     * Unable to fully structure code
     */
    public String getKeyWithOptionalCaptureCode(boolean includeCode) {
        block6: {
            builder = new StringBuilder();
            var4_3 = this.typeVar;
            if (var4_3 instanceof Type.CapturedType) {
                capturedType = (Type.CapturedType)var4_3;
                try {
                    builder.append('!');
                    JavacTypeBinding.getKey(builder, capturedType.wildcard, false, true, this.resolver);
                    if (includeCode) {
                        builder.append(((long)capturedType.hashCode() & 0xFFFFFFFFL) % 997L);
                        builder.append(';');
                    }
                    return builder.toString();
                }
                catch (JavacBindingResolver.BindingKeyException e) {
                    return null;
                }
            }
            if (this.sym.owner == null || (ownerBinding = this.bindingResolver.bindings.getBinding(this.sym.owner, null)) == null) break block6;
            if (!(ownerBinding instanceof JavacTypeBinding)) ** GOTO lbl-1000
            jctb = (JavacTypeBinding)ownerBinding;
            if (!(ownerBinding instanceof JavacTypeVariableBinding)) {
                builder.append(jctb.getKey(false, true));
            } else lbl-1000:
            // 2 sources

            {
                builder.append(ownerBinding.getKey());
            }
        }
        builder.append(":T");
        builder.append(this.sym.getSimpleName());
        builder.append(";");
        return builder.toString();
    }

    @Override
    public String getQualifiedName() {
        if (this.typeVar instanceof Type.CapturedType) {
            return "";
        }
        return ((Name)this.sym.getSimpleName()).toString();
    }

    @Override
    public String getBinaryName() {
        IMethodBinding declaringMethod = this.getDeclaringMethod();
        if (declaringMethod != null) {
            return declaringMethod.getDeclaringClass().getBinaryName() + "$(" + Arrays.stream(declaringMethod.getParameterTypes()).map(IBinding::getKey).collect(Collectors.joining(",")) + ")" + declaringMethod.getReturnType().getKey() + "$" + this.getQualifiedName();
        }
        ITypeBinding declaring = this.getDeclaringClass();
        return declaring != null ? declaring.getBinaryName() + "$" + this.getQualifiedName() : super.getBinaryName();
    }

    static String getTypeVariableKey(Symbol.TypeVariableSymbol sym, JavacBindingResolver resolver) throws JavacBindingResolver.BindingKeyException {
        StringBuilder builder = new StringBuilder();
        builder.append(sym.getSimpleName());
        for (Type bound : sym.getBounds()) {
            builder.append(':');
            if (bound.isParameterized()) {
                builder.append(':');
            }
            JavacTypeBinding.getKey(builder, bound, false, false, true, resolver);
        }
        return builder.toString();
    }

    @Override
    public String toString() {
        Type.TypeVar typeVar = this.typeVar;
        if (typeVar instanceof Type.CapturedType) {
            Type.CapturedType capturedType = (Type.CapturedType)typeVar;
            StringBuilder builder = new StringBuilder();
            builder.append("capture#");
            builder.append(((long)capturedType.hashCode() & 0xFFFFFFFFL) % 997L);
            builder.append("-of");
            builder.append(this.getQualifiedNameImpl(capturedType.wildcard, capturedType.wildcard.tsym, capturedType.wildcard.tsym.owner, true));
            return builder.toString();
        }
        return this.getKey();
    }
}

