/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import org.gradle.internal.impldep.org.jspecify.annotations.Nullable;

public abstract class Cast {
    public static <O, I> O cast(Class<O> outputType, I object) {
        try {
            return outputType.cast(object);
        }
        catch (ClassCastException e) {
            throw new ClassCastException(String.format("Failed to cast object %s of type %s to target type %s", object, object.getClass().getName(), outputType.getName()));
        }
    }

    public static <O, I> @Nullable O castNullable(Class<O> outputType, @Nullable I object) {
        if (object == null) {
            return null;
        }
        return Cast.cast(outputType, object);
    }

    public static <T> @Nullable T uncheckedCast(@Nullable Object object) {
        return (T)object;
    }

    public static <T> T uncheckedNonnullCast(Object object) {
        return (T)object;
    }
}

