/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac.dom;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.internal.compiler.parser.RecoveryScanner;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.TerminalToken;
import org.eclipse.jdt.internal.core.Annotation;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.MemberValuePair;

public class JavacVariableBindingAnnotUtil {
    public static Annotation modelAnnotation(org.eclipse.jdt.core.dom.Annotation domAnnotation, JavaElement parent) {
        IMemberValuePair[] members;
        if (domAnnotation instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)domAnnotation;
            members = (IMemberValuePair[])normalAnnotation.values().stream().map(domMemberValuePair -> {
                Map.Entry<Object, Integer> value = JavacVariableBindingAnnotUtil.memberValueToEntries(domMemberValuePair.getValue());
                return new MemberValuePair(domMemberValuePair.getName().toString(), value.getKey(), value.getValue().intValue());
            }).toArray(IMemberValuePair[]::new);
        } else if (domAnnotation instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation single = (SingleMemberAnnotation)domAnnotation;
            Map.Entry<Object, Integer> value = JavacVariableBindingAnnotUtil.memberValueToEntries(single.getValue());
            members = new IMemberValuePair[]{new MemberValuePair("value", value.getKey(), value.getValue().intValue())};
        } else {
            members = new IMemberValuePair[]{};
        }
        return new Annotation(parent, domAnnotation.getTypeName().toString()){

            public IMemberValuePair[] getMemberValuePairs() {
                return members;
            }
        };
    }

    public static Map.Entry<Object, Integer> memberValueToEntries(Expression dom) {
        SimpleName name;
        if (dom == null || dom instanceof NullLiteral || dom instanceof SimpleName && ("MISSING".equals((name = (SimpleName)dom).getIdentifier()) || Arrays.equals(RecoveryScanner.FAKE_IDENTIFIER, name.getIdentifier().toCharArray()))) {
            return new AbstractMap.SimpleEntry<Object, Integer>(null, 14);
        }
        if (dom instanceof StringLiteral) {
            StringLiteral stringValue = (StringLiteral)dom;
            try {
                return new AbstractMap.SimpleEntry<Object, Integer>(stringValue.getLiteralValue(), 9);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (dom instanceof BooleanLiteral) {
            BooleanLiteral booleanValue = (BooleanLiteral)dom;
            return new AbstractMap.SimpleEntry<Object, Integer>(booleanValue.booleanValue(), 8);
        }
        if (dom instanceof CharacterLiteral) {
            CharacterLiteral charValue = (CharacterLiteral)dom;
            return new AbstractMap.SimpleEntry<Object, Integer>(Character.valueOf(charValue.charValue()), 4);
        }
        if (dom instanceof TypeLiteral) {
            TypeLiteral typeLiteral = (TypeLiteral)dom;
            return new AbstractMap.SimpleEntry<Type, Integer>(typeLiteral.getType(), 11);
        }
        if (dom instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)dom;
            return new AbstractMap.SimpleEntry<Object, Integer>(simpleName.toString(), 13);
        }
        if (dom instanceof QualifiedName) {
            QualifiedName qualifiedName = (QualifiedName)dom;
            return new AbstractMap.SimpleEntry<Object, Integer>(qualifiedName.toString(), 12);
        }
        if (dom instanceof org.eclipse.jdt.core.dom.Annotation) {
            org.eclipse.jdt.core.dom.Annotation annotation = (org.eclipse.jdt.core.dom.Annotation)dom;
            return new AbstractMap.SimpleEntry<Annotation, Integer>(JavacVariableBindingAnnotUtil.modelAnnotation(annotation, null), 10);
        }
        if (dom instanceof ArrayInitializer) {
            ArrayInitializer arrayInitializer = (ArrayInitializer)dom;
            List<Map.Entry> values = arrayInitializer.expressions().stream().map(x -> JavacVariableBindingAnnotUtil.memberValueToEntries(x)).toList();
            List<Integer> types = values.stream().map(Map.Entry::getValue).distinct().toList();
            return new AbstractMap.SimpleEntry<Object[], Integer>(values.stream().map(Map.Entry::getKey).toArray(), types.size() == 1 ? types.get(0) : 14);
        }
        if (dom instanceof NumberLiteral) {
            NumberLiteral number = (NumberLiteral)dom;
            String token = number.getToken();
            int type = JavacVariableBindingAnnotUtil.annotationValuePairType(token);
            Object value = token;
            if (type == 7 && token.endsWith("L") || type == 5 && token.endsWith("f")) {
                value = token.substring(0, token.length() - 1);
            }
            if (value instanceof String) {
                String valueString = value;
                switch (type) {
                    case 1: {
                        try {
                            value = Integer.parseInt(valueString);
                        }
                        catch (NumberFormatException e) {
                            type = 7;
                            value = Long.parseLong(valueString);
                        }
                        break;
                    }
                    case 7: {
                        value = Long.parseLong(valueString);
                        break;
                    }
                    case 3: {
                        value = Short.parseShort(valueString);
                        break;
                    }
                    case 2: {
                        value = Byte.parseByte(valueString);
                        break;
                    }
                    case 5: {
                        value = Float.valueOf(Float.parseFloat(valueString));
                        break;
                    }
                    case 6: {
                        value = Double.parseDouble(valueString);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Type not (yet?) supported");
                    }
                }
            }
            return new AbstractMap.SimpleEntry<Object, Integer>(value, type);
        }
        if (dom instanceof PrefixExpression) {
            PrefixExpression prefixExpression = (PrefixExpression)dom;
            Expression operand = prefixExpression.getOperand();
            if (!(operand instanceof NumberLiteral) && !(operand instanceof BooleanLiteral)) {
                return new AbstractMap.SimpleEntry<Object, Integer>(null, 14);
            }
            Map.Entry<Object, Integer> entry = JavacVariableBindingAnnotUtil.memberValueToEntries(prefixExpression.getOperand());
            return new AbstractMap.SimpleEntry<Object, Integer>(prefixExpression.getOperator().toString() + String.valueOf(entry.getKey()), entry.getValue());
        }
        return new AbstractMap.SimpleEntry<Object, Integer>(null, 14);
    }

    private static int annotationValuePairType(String token) {
        Scanner scanner = new Scanner();
        scanner.setSource(token.toCharArray());
        try {
            TerminalToken tokenType = scanner.getNextToken();
            return switch (tokenType) {
                case TerminalToken.TokenNameDoubleLiteral -> 6;
                case TerminalToken.TokenNameIntegerLiteral -> 1;
                case TerminalToken.TokenNameFloatingPointLiteral -> 5;
                case TerminalToken.TokenNameLongLiteral -> 7;
                case TerminalToken.TokenNameMINUS -> {
                    switch (scanner.getNextToken()) {
                        case TokenNameDoubleLiteral: {
                            yield 6;
                        }
                        case TokenNameIntegerLiteral: {
                            yield 1;
                        }
                        case TokenNameFloatingPointLiteral: {
                            yield 5;
                        }
                        case TokenNameLongLiteral: {
                            yield 7;
                        }
                    }
                    throw new IllegalArgumentException("Invalid number literal : >" + token + "<");
                }
                default -> throw new IllegalArgumentException("Invalid number literal : >" + token + "<");
            };
        }
        catch (InvalidInputException ex) {
            ILog.get().error(ex.getMessage(), (Throwable)ex);
            return 14;
        }
    }
}

