/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.model;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.oniguruma.OnigRegExp;
import org.eclipse.tm4e.core.internal.oniguruma.OnigResult;
import org.eclipse.tm4e.core.internal.oniguruma.OnigString;

public abstract class RegExPattern {
    public static RegExPattern of(String pattern) {
        return RegExPattern.of(pattern, null);
    }

    public static RegExPattern of(String pattern, @Nullable String flags) {
        try {
            return new JavaRegExPattern(pattern, flags);
        }
        catch (Exception ex) {
            return new OnigRegExPattern(pattern, flags);
        }
    }

    public static @Nullable RegExPattern ofNullable(@Nullable String pattern) {
        return RegExPattern.ofNullable(pattern, null);
    }

    public static @Nullable RegExPattern ofNullable(@Nullable String pattern, @Nullable String flags) {
        if (pattern != null) {
            try {
                return new JavaRegExPattern(pattern, flags);
            }
            catch (Exception ex) {
                try {
                    return new OnigRegExPattern(pattern, flags);
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                }
            }
        }
        return null;
    }

    public abstract boolean matchesFully(String var1);

    public abstract boolean matchesPartially(String var1);

    public abstract String pattern();

    public String toString() {
        return this.pattern();
    }

    private static final class JavaRegExPattern
    extends RegExPattern {
        final Pattern pattern;

        JavaRegExPattern(String pattern, @Nullable String flags) throws PatternSyntaxException {
            this.pattern = Pattern.compile((String)(flags == null ? pattern : pattern + "(?" + flags + ")"));
        }

        @Override
        public boolean matchesFully(String text) {
            return this.pattern.matcher(text).matches();
        }

        @Override
        public boolean matchesPartially(String text) {
            return this.pattern.matcher(text).find();
        }

        @Override
        public String pattern() {
            return this.pattern.pattern();
        }
    }

    private static final class OnigRegExPattern
    extends RegExPattern {
        final OnigRegExp regex;

        OnigRegExPattern(String pattern, @Nullable String flags) throws PatternSyntaxException {
            this.regex = new OnigRegExp(pattern, flags != null && flags.contains("i"));
        }

        @Override
        public boolean matchesFully(String text) {
            OnigResult result = this.regex.search(OnigString.of((String)text), 0);
            return result != null && result.count() == 1 && result.lengthAt(0) == text.length();
        }

        @Override
        public boolean matchesPartially(String text) {
            return this.regex.search(OnigString.of((String)text), 0) != null;
        }

        @Override
        public String pattern() {
            return this.regex.pattern();
        }
    }
}

