/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.theme;

import org.eclipse.jdt.annotation.Nullable;

public class RGB {
    private static final System.Logger LOGGER = System.getLogger(RGB.class.getName());
    public final int red;
    public final int green;
    public final int blue;

    public static @Nullable RGB fromHex(@Nullable String hex) {
        Object b;
        Object g;
        Object r;
        if (hex == null || hex.isBlank()) {
            return null;
        }
        int offset = hex.startsWith("#") ? 1 : 0;
        int digitLength = hex.length() - offset;
        if (digitLength == 3) {
            String r0 = hex.substring(offset + 0, offset + 1);
            String g0 = hex.substring(offset + 1, offset + 2);
            String b0 = hex.substring(offset + 2, offset + 3);
            r = r0 + r0;
            g = g0 + g0;
            b = b0 + b0;
        } else if (digitLength == 6) {
            r = hex.substring(offset + 0, offset + 2);
            g = hex.substring(offset + 2, offset + 4);
            b = hex.substring(offset + 4, offset + 6);
        } else {
            LOGGER.log(System.Logger.Level.WARNING, "Invalid hex color string '" + hex + "': expected format '#RGB' (3 hex digits) or '#RRGGBB' (6 hex digits)");
            return null;
        }
        return new RGB(Integer.parseInt((String)r, 16), Integer.parseInt((String)g, 16), Integer.parseInt((String)b, 16));
    }

    public RGB(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public String toString() {
        return "RGB(" + this.red + "," + this.green + "," + this.blue + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.blue;
        result = 31 * result + this.green;
        result = 31 * result + this.red;
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RGB other = (RGB)obj;
        if (this.blue != other.blue) {
            return false;
        }
        if (this.green != other.green) {
            return false;
        }
        return this.red == other.red;
    }
}

