/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.buildpath;

import org.eclipse.ajdt.core.AspectJCorePreferences;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AJBuildPathAction {
    protected IFile jarFile;
    protected IClasspathEntry cpEntry;
    protected IProject project;

    private static IFile getCandidate(IAdaptable element) throws JavaModelException {
        IResource resource = (IResource)element.getAdapter(IResource.class);
        if (!(resource instanceof IFile) || !ArchiveFileFilter.isArchivePath((IPath)resource.getFullPath(), (boolean)true)) {
            return null;
        }
        IJavaProject project = JavaCore.create((IProject)resource.getProject());
        if (project != null && project.exists() && project.findPackageFragmentRoot(resource.getFullPath()) == null) {
            return (IFile)resource;
        }
        return null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    protected static IFile getJARFile(IStructuredSelection selection) throws JavaModelException {
        IFile file;
        if (selection.size() != 1) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (element instanceof IAdaptable && (file = AJBuildPathAction.getCandidate((IAdaptable)element)) != null) {
            return file;
        }
        return null;
    }

    protected boolean checkIfAddingOutjar(IProject project) {
        String inpath = this.jarFile.getFullPath().toPortableString();
        String outJar = AspectJCorePreferences.getProjectOutJar((IProject)project);
        return outJar.length() > 0 && inpath.indexOf(outJar) != -1;
    }
}

