/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.build;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.core.exports.FeatureExportOperation;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FeatureExportJob
extends Job {
    protected FeatureExportInfo fInfo;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;

    public FeatureExportJob(FeatureExportInfo info) {
        this(info, PDEUIMessages.FeatureExportJob_name);
    }

    protected FeatureExportJob(FeatureExportInfo info, String name) {
        super(name);
        this.fInfo = info;
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    protected IStatus run(IProgressMonitor monitor) {
        String errorMessage = null;
        FeatureExportOperation op = this.createOperation();
        try {
            op.run(monitor);
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            final CoreException e = coreException;
            final Display display = FeatureExportJob.getStandardDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    MultiStatus status = new MultiStatus(e.getStatus().getPlugin(), e.getStatus().getCode(), new IStatus[]{e.getStatus()}, "Export feature error", (Throwable)e);
                    ErrorDialog.openError((Shell)display.getActiveShell(), (String)"Export feature error", (String)"Problem when exporting feature", (IStatus)status);
                    FeatureExportJob.this.done((IStatus)new Status(0, PDEPlugin.getPluginId(), 0, "", null));
                }
            });
            return Job.ASYNC_FINISH;
        }
        if (errorMessage == null && op.hasErrors()) {
            errorMessage = this.getLogFoundMessage();
        }
        if (errorMessage != null) {
            final String em = errorMessage;
            FeatureExportJob.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    FeatureExportJob.this.asyncNotifyExportException(em);
                }
            });
            return Job.ASYNC_FINISH;
        }
        return new Status(0, PDEPlugin.getPluginId(), 0, "", null);
    }

    protected FeatureExportOperation createOperation() {
        return new FeatureExportOperation(this.fInfo);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private void asyncNotifyExportException(String errorMessage) {
        FeatureExportJob.getStandardDisplay().beep();
        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)"Export feature error", (String)errorMessage);
        this.done((IStatus)new Status(0, PDEPlugin.getPluginId(), 0, "", null));
    }

    protected String getLogFoundMessage() {
        return NLS.bind((String)"Errors occurred during the operation.  A zip file containing the build logs has been generated and placed at \"{0}\".", (Object)this.fInfo.destinationDirectory);
    }

    static {
        Factory factory = new Factory("FeatureExportJob.java", Class.forName("org.eclipse.ajdt.internal.ui.build.FeatureExportJob"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.build.FeatureExportJob", "org.eclipse.core.runtime.CoreException:", "e:"), 62);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "run", "org.eclipse.ajdt.internal.ui.build.FeatureExportJob", "org.eclipse.core.runtime.IProgressMonitor:", "monitor:", "", "org.eclipse.core.runtime.IStatus"), 57);
    }

    class SchedulingRule
    implements ISchedulingRule {
        SchedulingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule instanceof SchedulingRule || rule instanceof IResource;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof SchedulingRule;
        }
    }
}

