/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.markers;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.ajdt.internal.ui.markers.DeleteAJMarkers;
import org.eclipse.ajdt.internal.ui.markers.UpdateAJMarkers;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;

public class DeleteAndUpdateAJMarkersJob
extends Job {
    public static final Object UPDATE_DELETE_AJ_MARKERS_FAMILY = new Object();
    private DeleteAJMarkers delete;
    private UpdateAJMarkers update;
    private IProject project;
    private boolean deleteOnly = false;
    private ISchedulingRule rule;

    public DeleteAndUpdateAJMarkersJob(IProject project) {
        super("Delete and update AspectJ markers for " + project.getName());
        this.project = project;
        this.update = new UpdateAJMarkers(project);
        this.delete = new DeleteAJMarkers(project);
        this.rule = this.createSchedulingRule(project, null);
    }

    public DeleteAndUpdateAJMarkersJob(IProject project, File[] sourceFiles) {
        super("Delete and update AspectJ markers for " + project.getName());
        IFile[] iFiles = DeleteAndUpdateAJMarkersJob.javaFileToIFile(sourceFiles);
        this.update = new UpdateAJMarkers(project, iFiles);
        this.delete = new DeleteAJMarkers(project, iFiles);
        this.rule = this.createSchedulingRule(project, iFiles);
    }

    protected IStatus run(IProgressMonitor monitor) {
        MultiStatus multiStatus;
        try {
            InternalJob.manager.beginRule(this.rule, monitor);
            IStatus deleteStatus = this.delete.run(monitor);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IStatus updateStatus = !this.deleteOnly ? this.update.run(monitor) : Status.OK_STATUS;
            multiStatus = new MultiStatus("org.eclipse.ajdt.ui", Math.max(updateStatus.getCode(), deleteStatus.getCode()), new IStatus[]{deleteStatus, updateStatus}, "Finished deleting and updating markers", null);
        }
        catch (Throwable throwable) {
            try {
                InternalJob.manager.endRule(this.rule);
                throw throwable;
            }
            catch (OperationCanceledException operationCanceledException) {
                return Status.CANCEL_STATUS;
            }
        }
        InternalJob.manager.endRule(this.rule);
        return multiStatus;
    }

    public void doDeleteOnly(boolean deleteOnly) {
        this.deleteOnly = deleteOnly;
    }

    public boolean belongsTo(Object family) {
        return family == UPDATE_DELETE_AJ_MARKERS_FAMILY;
    }

    private ISchedulingRule createSchedulingRule(IProject thisProject, IFile[] sourceFiles) {
        IProject updateRule;
        if (sourceFiles != null) {
            ISchedulingRule[] subRules = new ISchedulingRule[sourceFiles.length];
            int i = 0;
            while (i < sourceFiles.length) {
                subRules[i] = sourceFiles[i];
                ++i;
            }
            updateRule = new MultiRule(subRules);
        } else {
            updateRule = this.project;
        }
        return updateRule;
    }

    static IFile[] javaFileToIFile(File[] files) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ArrayList<IFile> iFiles = new ArrayList<IFile>(files.length);
        int i = 0;
        while (i < files.length) {
            IFile[] newFiles = workspace.getRoot().findFilesForLocationURI(files[i].toURI());
            int j = 0;
            while (j < newFiles.length) {
                iFiles.add(newFiles[j]);
                ++j;
            }
            ++i;
        }
        return iFiles.toArray(new IFile[iFiles.size()]);
    }
}

