/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.util.ArrayList;
import java.util.Collections;
import org.aspectj.ajdt.internal.compiler.ast.AdviceDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.DeclareDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeConstructorDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeFieldDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeMethodDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.PointcutDeclaration;
import org.aspectj.ajdt.internal.compiler.lookup.AjLookupEnvironment;
import org.aspectj.asm.IProgramElement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.model.AsmRelationshipUtils;
import org.aspectj.weaver.patterns.DeclareAnnotation;
import org.aspectj.weaver.patterns.DeclareErrorOrWarning;
import org.aspectj.weaver.patterns.DeclareParents;
import org.aspectj.weaver.patterns.DeclarePrecedence;
import org.aspectj.weaver.patterns.DeclareSoft;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.TypePattern;
import org.aspectj.weaver.patterns.TypePatternList;

public class AsmElementFormatter {
    public void genLabelAndKind(MethodDeclaration methodDeclaration, IProgramElement node) {
        if (methodDeclaration instanceof AdviceDeclaration) {
            AdviceDeclaration ad = (AdviceDeclaration)methodDeclaration;
            node.setKind(IProgramElement.Kind.ADVICE);
            if (ad.kind == AdviceKind.Around) {
                node.setCorrespondingType(ad.returnType.toString());
            }
            StringBuffer details = new StringBuffer();
            if (ad.pointcutDesignator != null) {
                details.append(AsmRelationshipUtils.genPointcutDetails((Pointcut)ad.pointcutDesignator.getPointcut()));
            } else {
                details.append("<abstract pointcut>");
            }
            node.setName(ad.kind.toString());
            node.setDetails(details.toString());
            this.setParameters(methodDeclaration, node);
        } else if (methodDeclaration instanceof PointcutDeclaration) {
            node.setKind(IProgramElement.Kind.POINTCUT);
            node.setName(this.translatePointcutName(new String(methodDeclaration.selector)));
            this.setParameters(methodDeclaration, node);
        } else if (methodDeclaration instanceof DeclareDeclaration) {
            DeclareDeclaration declare = (DeclareDeclaration)methodDeclaration;
            String name = "declare ";
            if (declare.declareDecl instanceof DeclareErrorOrWarning) {
                DeclareErrorOrWarning deow = (DeclareErrorOrWarning)declare.declareDecl;
                if (deow.isError()) {
                    node.setKind(IProgramElement.Kind.DECLARE_ERROR);
                    name = name + "error";
                } else {
                    node.setKind(IProgramElement.Kind.DECLARE_WARNING);
                    name = name + "warning";
                }
                node.setName(name);
                node.setDetails("\"" + AsmRelationshipUtils.genDeclareMessage((String)deow.getMessage()) + "\"");
            } else if (declare.declareDecl instanceof DeclareParents) {
                node.setKind(IProgramElement.Kind.DECLARE_PARENTS);
                DeclareParents dp = (DeclareParents)declare.declareDecl;
                node.setName(name + "parents");
                String kindOfDP = null;
                StringBuffer details = new StringBuffer("");
                TypePattern[] newParents = dp.getParents().getTypePatterns();
                for (int i = 0; i < newParents.length; ++i) {
                    String typename;
                    TypePattern tp = newParents[i];
                    UnresolvedType tx = tp.getExactType();
                    if (kindOfDP == null) {
                        kindOfDP = "implements ";
                        try {
                            ResolvedType rtx = tx.resolve(((AjLookupEnvironment)declare.scope.environment()).factory.getWorld());
                            if (!rtx.isInterface()) {
                                kindOfDP = "extends ";
                            }
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if ((typename = tp.toString()).lastIndexOf(".") != -1) {
                        typename = typename.substring(typename.lastIndexOf(".") + 1);
                    }
                    details.append(typename);
                    if (i + 1 >= newParents.length) continue;
                    details.append(",");
                }
                node.setDetails(kindOfDP + details.toString());
            } else if (declare.declareDecl instanceof DeclareSoft) {
                node.setKind(IProgramElement.Kind.DECLARE_SOFT);
                DeclareSoft ds = (DeclareSoft)declare.declareDecl;
                node.setName(name + "soft");
                node.setDetails(this.genTypePatternLabel(ds.getException()));
            } else if (declare.declareDecl instanceof DeclarePrecedence) {
                node.setKind(IProgramElement.Kind.DECLARE_PRECEDENCE);
                DeclarePrecedence ds = (DeclarePrecedence)declare.declareDecl;
                node.setName(name + "precedence");
                node.setDetails(this.genPrecedenceListLabel(ds.getPatterns()));
            } else if (declare.declareDecl instanceof DeclareAnnotation) {
                DeclareAnnotation deca = (DeclareAnnotation)declare.declareDecl;
                String thekind = deca.getKind().toString();
                node.setName(name + "@" + thekind.substring(3));
                if (deca.getKind() == DeclareAnnotation.AT_CONSTRUCTOR) {
                    node.setKind(IProgramElement.Kind.DECLARE_ANNOTATION_AT_CONSTRUCTOR);
                } else if (deca.getKind() == DeclareAnnotation.AT_FIELD) {
                    node.setKind(IProgramElement.Kind.DECLARE_ANNOTATION_AT_FIELD);
                } else if (deca.getKind() == DeclareAnnotation.AT_METHOD) {
                    node.setKind(IProgramElement.Kind.DECLARE_ANNOTATION_AT_METHOD);
                } else if (deca.getKind() == DeclareAnnotation.AT_TYPE) {
                    node.setKind(IProgramElement.Kind.DECLARE_ANNOTATION_AT_TYPE);
                }
                node.setDetails(this.genDecaLabel(deca));
            } else {
                node.setKind(IProgramElement.Kind.ERROR);
                node.setName("<unknown declare>");
            }
        } else if (methodDeclaration instanceof InterTypeDeclaration) {
            InterTypeDeclaration itd = (InterTypeDeclaration)methodDeclaration;
            String fqname = itd.getOnType().toString();
            if (fqname.indexOf(".") != -1) {
                fqname = fqname.substring(fqname.lastIndexOf(".") + 1);
            }
            String name = fqname + "." + new String(itd.getDeclaredSelector());
            if (methodDeclaration instanceof InterTypeFieldDeclaration) {
                node.setKind(IProgramElement.Kind.INTER_TYPE_FIELD);
                node.setName(name);
            } else if (methodDeclaration instanceof InterTypeMethodDeclaration) {
                node.setKind(IProgramElement.Kind.INTER_TYPE_METHOD);
                node.setName(name);
            } else if (methodDeclaration instanceof InterTypeConstructorDeclaration) {
                node.setKind(IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR);
                node.setName(itd.getOnType().toString() + "." + itd.getOnType().toString().replace('.', '_'));
            } else {
                node.setKind(IProgramElement.Kind.ERROR);
                node.setName(name);
            }
            node.setCorrespondingType(new String(itd.returnType.resolvedType.readableName()));
            if (node.getKind() != IProgramElement.Kind.INTER_TYPE_FIELD) {
                this.setParameters(methodDeclaration, node);
            }
        } else {
            if (methodDeclaration.isConstructor()) {
                node.setKind(IProgramElement.Kind.CONSTRUCTOR);
            } else {
                node.setKind(IProgramElement.Kind.METHOD);
                if (methodDeclaration != null && methodDeclaration.annotations != null && methodDeclaration.scope != null) {
                    for (int i = 0; i < methodDeclaration.annotations.length; ++i) {
                        Annotation annotation = methodDeclaration.annotations[i];
                        String annotationSig = new String(annotation.type.getTypeBindingPublic(methodDeclaration.scope).signature());
                        if (annotationSig.charAt(1) != 'o') continue;
                        if ("Lorg/aspectj/lang/annotation/Pointcut;".equals(annotationSig)) {
                            node.setKind(IProgramElement.Kind.POINTCUT);
                            node.setAnnotationStyleDeclaration(true);
                            break;
                        }
                        if (!"Lorg/aspectj/lang/annotation/Before;".equals(annotationSig) && !"Lorg/aspectj/lang/annotation/After;".equals(annotationSig) && !"Lorg/aspectj/lang/annotation/AfterReturning;".equals(annotationSig) && !"Lorg/aspectj/lang/annotation/AfterThrowing;".equals(annotationSig) && !"Lorg/aspectj/lang/annotation/Around;".equals(annotationSig)) continue;
                        node.setKind(IProgramElement.Kind.ADVICE);
                        node.setAnnotationStyleDeclaration(true);
                        node.setDetails("<anonymous pointcut>");
                        break;
                    }
                }
            }
            node.setName(new String(methodDeclaration.selector));
            this.setParameters(methodDeclaration, node);
        }
    }

    private String genDecaLabel(DeclareAnnotation deca) {
        StringBuffer sb = new StringBuffer("");
        sb.append(deca.getPatternAsString());
        sb.append(" : ");
        sb.append(deca.getAnnotationString());
        return sb.toString();
    }

    private String genPrecedenceListLabel(TypePatternList list) {
        String tpList = "";
        for (int i = 0; i < list.size(); ++i) {
            tpList = tpList + this.genTypePatternLabel(list.get(i));
            if (i >= list.size() - 1) continue;
            tpList = tpList + ", ";
        }
        return tpList;
    }

    private String handleSigForReference(TypeReference ref, TypeBinding tb, MethodScope scope) {
        try {
            StringBuffer sb = new StringBuffer();
            this.createHandleSigForReference(ref, tb, scope, sb);
            return sb.toString();
        }
        catch (Throwable t) {
            System.err.println("Problem creating handle sig for this type reference " + ref);
            t.printStackTrace(System.err);
            return null;
        }
    }

    private void createHandleSigForReference(TypeReference ref, TypeBinding tb, MethodScope scope, StringBuffer handleSig) {
        if (ref instanceof Wildcard) {
            Wildcard w = (Wildcard)ref;
            if (w.bound == null) {
                handleSig.append('*');
            } else {
                handleSig.append('+');
                TypeBinding typeB = w.bound.resolvedType;
                if (typeB == null) {
                    typeB = w.bound.resolveType(scope);
                }
                this.createHandleSigForReference(w.bound, typeB, scope, handleSig);
            }
        } else if (ref instanceof ParameterizedSingleTypeReference) {
            ParameterizedSingleTypeReference pstr = (ParameterizedSingleTypeReference)ref;
            for (int i = pstr.dimensions(); i > 0; --i) {
                handleSig.append("\\[");
            }
            handleSig.append('Q').append(pstr.token);
            TypeReference[] typeRefs = pstr.typeArguments;
            if (typeRefs != null && typeRefs.length > 0) {
                handleSig.append("\\<");
                for (int i = 0; i < typeRefs.length; ++i) {
                    TypeReference typeR = typeRefs[i];
                    TypeBinding typeB = typeR.resolvedType;
                    if (typeB == null) {
                        typeB = typeR.resolveType(scope);
                    }
                    this.createHandleSigForReference(typeR, typeB, scope, handleSig);
                }
                handleSig.append('>');
            }
            handleSig.append(';');
        } else if (ref instanceof ArrayTypeReference) {
            ArrayTypeReference atr = (ArrayTypeReference)ref;
            for (int i = 0; i < atr.dimensions; ++i) {
                handleSig.append("\\[");
            }
            TypeBinding typeB = atr.resolvedType;
            if (typeB == null) {
                typeB = atr.resolveType(scope);
            }
            if (typeB.leafComponentType().isBaseType()) {
                handleSig.append(tb.leafComponentType().signature());
            } else {
                handleSig.append('Q').append(atr.token).append(';');
            }
        } else if (ref instanceof SingleTypeReference) {
            SingleTypeReference str = (SingleTypeReference)ref;
            if (tb.isBaseType()) {
                handleSig.append(tb.signature());
            } else {
                handleSig.append('Q').append(str.token).append(';');
            }
        } else if (ref instanceof ParameterizedQualifiedTypeReference) {
            int i;
            ParameterizedQualifiedTypeReference pstr = (ParameterizedQualifiedTypeReference)ref;
            char[][] tokens = pstr.tokens;
            for (i = pstr.dimensions(); i > 0; --i) {
                handleSig.append("\\[");
            }
            handleSig.append('Q');
            for (i = 0; i < tokens.length; ++i) {
                if (i > 0) {
                    handleSig.append('.');
                }
                handleSig.append(tokens[i]);
                TypeReference[] typeRefs = pstr.typeArguments[i];
                if (typeRefs == null || typeRefs.length <= 0) continue;
                handleSig.append("\\<");
                for (int j = 0; j < typeRefs.length; ++j) {
                    TypeReference typeR = typeRefs[j];
                    TypeBinding typeB = typeR.resolvedType;
                    if (typeB == null) {
                        typeB = typeR.resolveType(scope);
                    }
                    this.createHandleSigForReference(typeR, typeB, scope, handleSig);
                }
                handleSig.append('>');
            }
            handleSig.append(';');
        } else if (ref instanceof ArrayQualifiedTypeReference) {
            ArrayQualifiedTypeReference atr = (ArrayQualifiedTypeReference)ref;
            for (int i = 0; i < atr.dimensions(); ++i) {
                handleSig.append("\\[");
            }
            TypeBinding typeB = atr.resolvedType;
            if (typeB == null) {
                typeB = atr.resolveType(scope);
            }
            if (typeB.leafComponentType().isBaseType()) {
                handleSig.append(tb.leafComponentType().signature());
            } else {
                char[][] tokens = atr.tokens;
                handleSig.append('Q');
                for (int i = 0; i < tokens.length; ++i) {
                    if (i > 0) {
                        handleSig.append('.');
                    }
                    handleSig.append(tokens[i]);
                }
                handleSig.append(';');
            }
        } else if (ref instanceof QualifiedTypeReference) {
            QualifiedTypeReference qtr = (QualifiedTypeReference)ref;
            char[][] tokens = qtr.tokens;
            handleSig.append('Q');
            for (int i = 0; i < tokens.length; ++i) {
                if (i > 0) {
                    handleSig.append('.');
                }
                handleSig.append(tokens[i]);
            }
            handleSig.append(';');
        } else {
            throw new RuntimeException("Cant handle " + ref.getClass());
        }
    }

    public void setParameters(AbstractMethodDeclaration md, IProgramElement pe) {
        Argument[] argArray = md.arguments;
        if (argArray == null) {
            pe.setParameterNames(Collections.EMPTY_LIST);
            pe.setParameterSignatures(Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        } else {
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<char[]> paramSigs = new ArrayList<char[]>();
            ArrayList<String> paramSourceRefs = new ArrayList<String>();
            boolean problemWithSourceRefs = false;
            for (int i = 0; i < argArray.length; ++i) {
                String argName = new String(argArray[i].name);
                if (!this.acceptArgument(argName, argArray[i].type.toString())) continue;
                TypeReference typeR = argArray[i].type;
                if (typeR != null && md.scope != null) {
                    TypeBinding typeB = typeR.resolvedType;
                    if (typeB == null) {
                        typeB = typeR.resolveType(md.scope);
                    }
                    paramSigs.add(typeB.genericTypeSignature());
                    String hsig = this.handleSigForReference(typeR, typeB, md.scope);
                    if (hsig == null) {
                        problemWithSourceRefs = true;
                    } else {
                        paramSourceRefs.add(hsig);
                    }
                }
                names.add(argName);
            }
            pe.setParameterNames(names);
            if (!paramSigs.isEmpty()) {
                pe.setParameterSignatures(paramSigs, problemWithSourceRefs ? null : paramSourceRefs);
            }
        }
    }

    private boolean acceptArgument(String name, String type) {
        if (name.charAt(0) != 'a' && type.charAt(0) != 'o') {
            return true;
        }
        return !name.startsWith("ajc$this_") && !type.equals("org.aspectj.lang.JoinPoint.StaticPart") && !type.equals("org.aspectj.lang.JoinPoint") && !type.equals("org.aspectj.runtime.internal.AroundClosure");
    }

    public String genTypePatternLabel(TypePattern tp) {
        String label;
        String TYPE_PATTERN_LITERAL = "<type pattern>";
        UnresolvedType typeX = tp.getExactType();
        if (!ResolvedType.isMissing((UnresolvedType)typeX)) {
            label = typeX.getName();
            if (tp.isIncludeSubtypes()) {
                label = label + "+";
            }
        } else {
            label = "<type pattern>";
        }
        return label;
    }

    private String translatePointcutName(String name) {
        int index = name.indexOf("$$") + 2;
        int endIndex = name.lastIndexOf(36);
        if (index != -1 && endIndex != -1) {
            return name.substring(index, endIndex);
        }
        return name;
    }
}

