/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.ajde;

import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.builder.IAJCompilerMonitor;
import org.eclipse.ajdt.core.text.CoreMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;

public class CoreBuildProgressMonitor
implements IAJCompilerMonitor {
    private IProject project;
    private IProgressMonitor monitor;
    private boolean buildWasCancelled = false;

    public CoreBuildProgressMonitor(IProject project) {
        this.project = project;
    }

    public void finish(boolean wasFullBuild) {
        AJLog.log(1, "AJC: Build finished. Was full build: " + wasFullBuild);
    }

    public void setProgressText(String text) {
        AJLog.log(4, "AJC: " + text);
    }

    public void begin() {
    }

    public void setProgress(double percentDone) {
    }

    public boolean isCancelRequested() {
        this.buildWasCancelled = this.monitor != null ? this.monitor.isCanceled() : false;
        return this.buildWasCancelled;
    }

    @Override
    public void prepare(IProgressMonitor eclipseMonitor) {
        this.buildWasCancelled = false;
        this.monitor = eclipseMonitor;
        if (eclipseMonitor != null) {
            eclipseMonitor.beginTask(CoreMessages.builder_taskname, 100);
        }
        AJLog.log(1, "AJC: Starting new build for project " + this.project.getName());
    }

    @Override
    public boolean buildWasCancelled() {
        return this.buildWasCancelled;
    }
}

