/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

public class Geometry {
    public static boolean linesIntersect(int ux, int uy, int vx, int vy, int sx, int sy, int tx, int ty) {
        long usX = (long)ux - (long)sx;
        long usY = (long)uy - (long)sy;
        long vsX = (long)vx - (long)sx;
        long vsY = (long)vy - (long)sy;
        long stX = (long)sx - (long)tx;
        long stY = (long)sy - (long)ty;
        if (Geometry.productSign(Geometry.cross(vsX, vsY, stX, stY), Geometry.cross(stX, stY, usX, usY)) >= 0) {
            long vuX = (long)vx - (long)ux;
            long vuY = (long)vy - (long)uy;
            long utX = (long)ux - (long)tx;
            long utY = (long)uy - (long)ty;
            return Geometry.productSign(Geometry.cross(-usX, -usY, vuX, vuY), Geometry.cross(vuX, vuY, utX, utY)) <= 0;
        }
        return false;
    }

    private static int productSign(long x, long y) {
        if (x == 0L || y == 0L) {
            return 0;
        }
        if (x < 0L ^ y < 0L) {
            return -1;
        }
        return 1;
    }

    private static long cross(long x1, long y1, long x2, long y2) {
        return x1 * y2 - x2 * y1;
    }
}

