/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.algorithms;

import java.util.Arrays;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.InternalNode;
import org.eclipse.zest.layouts.dataStructures.InternalRelationship;

public class GridLayoutAlgorithm
extends AbstractLayoutAlgorithm {
    private static final double PADDING_PERCENTAGE = 0.95;
    protected int rowPadding = 0;
    int rows;
    int cols;
    int numChildren;
    double colWidth;
    double rowHeight;
    double offsetX;
    double offsetY;
    int totalProgress;
    double h;
    double w;

    public void setLayoutArea(double x, double y, double width, double height) {
        throw new RuntimeException("Operation not implemented");
    }

    public GridLayoutAlgorithm(int styles) {
        super(styles);
    }

    public GridLayoutAlgorithm() {
        this(0);
    }

    protected int getCurrentLayoutStep() {
        return 0;
    }

    protected int getTotalNumberOfLayoutSteps() {
        return this.totalProgress;
    }

    protected void preLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double x, double y, double width, double height) {
        this.numChildren = entitiesToLayout.length;
        if (this.numChildren < 1) {
            return;
        }
        int[] colsAndRows = this.calculateNumberOfRowsAndCols(this.numChildren, x, y, width, height);
        this.cols = colsAndRows[0];
        this.rows = colsAndRows[1];
        this.totalProgress = this.rows + 2;
        this.fireProgressEvent(1, this.totalProgress);
        if (this.comparator != null) {
            Arrays.sort(entitiesToLayout, this.comparator);
        } else {
            Arrays.sort(entitiesToLayout);
        }
        this.fireProgressEvent(2, this.totalProgress);
        this.colWidth = width / (double)this.cols;
        this.rowHeight = height / (double)this.rows;
        double[] nodeSize = this.calculateNodeSize(this.colWidth, this.rowHeight);
        this.w = nodeSize[0];
        this.h = nodeSize[1];
        this.offsetX = (this.colWidth - this.w) / 2.0;
        this.offsetY = (this.rowHeight - this.h) / 2.0;
    }

    protected synchronized void applyLayoutInternal(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double boundsX, double boundsY, double boundsWidth, double boundsHeight) {
        int index = 0;
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                if (i * this.cols + j < this.numChildren) {
                    double xmove = boundsX + (double)j * this.colWidth + this.offsetX;
                    double ymove = boundsY + (double)i * this.rowHeight + this.offsetY;
                    InternalNode sn = entitiesToLayout[index++];
                    sn.setInternalLocation(xmove, ymove);
                    sn.setInternalSize(Math.max(this.w, 5.0), Math.max(this.h, 5.0));
                }
                ++j;
            }
            this.fireProgressEvent(2 + i, this.totalProgress);
            ++i;
        }
        this.updateLayoutLocations(entitiesToLayout);
        this.fireProgressEvent(this.totalProgress, this.totalProgress);
    }

    protected void postLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider) {
    }

    protected int[] calculateNumberOfRowsAndCols(int numChildren, double boundX, double boundY, double boundWidth, double boundHeight) {
        if (this.getEntityAspectRatio() == 1.0) {
            return this.calculateNumberOfRowsAndCols_square(numChildren, boundX, boundY, boundWidth, boundHeight);
        }
        return this.calculateNumberOfRowsAndCols_rectangular(numChildren);
    }

    /*
     * Unable to fully structure code
     */
    protected int[] calculateNumberOfRowsAndCols_square(int numChildren, double boundX, double boundY, double boundWidth, double boundHeight) {
        block6: {
            rows = Math.max(1, (int)Math.sqrt((double)numChildren * boundHeight / boundWidth));
            cols = Math.max(1, (int)Math.sqrt((double)numChildren * boundWidth / boundHeight));
            if (!(boundWidth <= boundHeight)) ** GOTO lbl19
            while (rows * cols > numChildren) {
                if (rows > 1) {
                    --rows;
                }
                if (rows * cols <= numChildren || cols <= 1) continue;
                --cols;
            }
            while (rows * cols < numChildren) {
                if (++rows * cols >= numChildren) continue;
                ++cols;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                if (cols > 1) {
                    --cols;
                }
                if (rows * cols <= numChildren || rows <= 1) continue;
                --rows;
lbl19:
                // 3 sources

                ** while (rows * cols > numChildren)
            }
lbl20:
            // 3 sources

            while (rows * cols < numChildren) {
                if (rows * ++cols >= numChildren) continue;
                ++rows;
            }
        }
        result = new int[]{cols, rows};
        return result;
    }

    protected int[] calculateNumberOfRowsAndCols_rectangular(int numChildren) {
        int rows = Math.max(1, (int)Math.ceil(Math.sqrt(numChildren)));
        int cols = Math.max(1, (int)Math.ceil(Math.sqrt(numChildren)));
        int[] result = new int[]{cols, rows};
        return result;
    }

    protected double[] calculateNodeSize(double colWidth, double rowHeight) {
        double childW = Math.max(5.0, 0.95 * colWidth);
        double childH = Math.max(5.0, 0.95 * (rowHeight - (double)this.rowPadding));
        double whRatio = colWidth / rowHeight;
        if (whRatio < this.getEntityAspectRatio()) {
            childH = childW / this.getEntityAspectRatio();
        } else {
            childW = childH * this.getEntityAspectRatio();
        }
        double[] result = new double[]{childW, childH};
        return result;
    }

    public void setRowPadding(int rowPadding) {
        if (rowPadding < 0) {
            return;
        }
        this.rowPadding = rowPadding;
    }

    protected boolean isValidConfiguration(boolean asynchronous, boolean continueous) {
        if (asynchronous && continueous) {
            return false;
        }
        if (asynchronous && !continueous) {
            return true;
        }
        if (!asynchronous && continueous) {
            return false;
        }
        return !asynchronous && !continueous;
    }
}

