/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.connect;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.CloseableBundleFile;
import org.eclipse.osgi.storage.bundlefile.MRUBundleFileList;
import org.osgi.framework.connect.ConnectContent;
import org.osgi.framework.connect.ConnectModule;

public class ConnectBundleFile
extends CloseableBundleFile<ConnectContent.ConnectEntry> {
    private final ConnectContent content;

    public ConnectBundleFile(ConnectModule module, File basefile, BundleInfo.Generation generation, MRUBundleFileList mruList, Debug debug) throws IOException {
        super(basefile, generation, mruList, debug);
        this.content = module.getContent();
    }

    @Override
    protected void doOpen() throws IOException {
        this.content.open();
    }

    @Override
    protected Iterable<String> getPaths() {
        try {
            return this.content.getEntries();
        }
        catch (IOException iOException) {
            return Collections.emptyList();
        }
    }

    @Override
    protected BundleEntry findEntry(String path) {
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return this.content.getEntry(path).map(connectEntry -> new ConnectBundleEntry((ConnectContent.ConnectEntry)connectEntry)).orElse(null);
    }

    @Override
    protected void doClose() throws IOException {
        this.content.close();
    }

    @Override
    protected void postClose() {
    }

    @Override
    protected InputStream doGetInputStream(ConnectContent.ConnectEntry entry) throws IOException {
        return entry.getInputStream();
    }

    public Map<String, String> getConnectHeaders() {
        if (!this.lockOpen()) {
            return null;
        }
        try {
            Map map = this.content.getHeaders().orElse(null);
            return map;
        }
        finally {
            this.releaseOpen();
        }
    }

    Optional<ClassLoader> getClassLoader() {
        return this.content.getClassLoader();
    }

    @Override
    public String toString() {
        return this.content.toString();
    }

    public class ConnectBundleEntry
    extends BundleEntry {
        private final ConnectContent.ConnectEntry connectEntry;

        public ConnectBundleEntry(ConnectContent.ConnectEntry entry) {
            this.connectEntry = entry;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return ConnectBundleFile.this.getInputStream(this.connectEntry);
        }

        @Override
        public byte[] getBytes() throws IOException {
            return this.connectEntry.getBytes();
        }

        @Override
        public long getSize() {
            return this.connectEntry.getContentLength();
        }

        @Override
        public String getName() {
            return this.connectEntry.getName();
        }

        @Override
        public long getTime() {
            return this.connectEntry.getLastModified();
        }

        @Override
        public URL getFileURL() {
            File file = ConnectBundleFile.this.getFile(this.getName(), false);
            if (file != null) {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {}
            }
            return null;
        }

        @Override
        public URL getLocalURL() {
            return ConnectBundleFile.this.getClassLoader().map(cl -> cl.getResource(this.getName())).orElse(null);
        }
    }
}

