/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.dom;

import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.dom.DOMNodePointer;
import org.w3c.dom.Node;

public class DOMNodeIterator
implements NodeIterator {
    private NodePointer parent;
    private NodeTest nodeTest;
    private Node node;
    private Node child = null;
    private boolean reverse;
    private int position = 0;

    public DOMNodeIterator(NodePointer parent, NodeTest nodeTest, boolean reverse, NodePointer startWith) {
        this.parent = parent;
        this.node = (Node)parent.getNode();
        if (startWith != null) {
            this.child = (Node)startWith.getNode();
        }
        this.nodeTest = nodeTest;
        this.reverse = reverse;
    }

    public NodePointer getNodePointer() {
        if (this.position == 0) {
            this.setPosition(1);
        }
        return this.child == null ? null : new DOMNodePointer(this.parent, this.child);
    }

    public int getPosition() {
        return this.position;
    }

    public boolean setPosition(int position) {
        while (this.position < position) {
            if (this.next()) continue;
            return false;
        }
        while (this.position > position) {
            if (this.previous()) continue;
            return false;
        }
        return true;
    }

    private boolean previous() {
        --this.position;
        if (!this.reverse) {
            this.child = this.position == 0 ? null : (this.child == null ? this.node.getLastChild() : this.child.getPreviousSibling());
            while (this.child != null && !this.testChild()) {
                this.child = this.child.getPreviousSibling();
            }
        } else {
            this.child = this.child.getNextSibling();
            while (this.child != null && !this.testChild()) {
                this.child = this.child.getNextSibling();
            }
        }
        return this.child != null;
    }

    private boolean next() {
        ++this.position;
        if (!this.reverse) {
            this.child = this.position == 1 ? (this.child == null ? this.node.getFirstChild() : this.child.getNextSibling()) : this.child.getNextSibling();
            while (this.child != null && !this.testChild()) {
                this.child = this.child.getNextSibling();
            }
        } else {
            this.child = this.position == 1 ? (this.child == null ? this.node.getLastChild() : this.child.getPreviousSibling()) : this.child.getPreviousSibling();
            while (this.child != null && !this.testChild()) {
                this.child = this.child.getPreviousSibling();
            }
        }
        return this.child != null;
    }

    private boolean testChild() {
        return DOMNodePointer.testNode(this.child, this.nodeTest);
    }
}

