/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBasicForLoopExpression;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XDoWhileExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XWhileExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.controlflow.BooleanResult;
import org.eclipse.xtext.xbase.controlflow.ConstantConditionsInterpreter;
import org.eclipse.xtext.xbase.controlflow.IEarlyExitComputer;

public class EarlyExitValidator
extends AbstractDeclarativeValidator {
    private final Map<EReference, EarlyExitKind> disallowedEarylExitReferences = ImmutableMap.of((Object)XbasePackage.Literals.XTRY_CATCH_FINALLY_EXPRESSION__FINALLY_EXPRESSION, (Object)((Object)EarlyExitKind.BOTH));
    @Inject
    private IEarlyExitComputer earlyExitComputer;
    @Inject
    private ConstantConditionsInterpreter constantExpressionInterpreter;

    protected Map<EReference, EarlyExitKind> getDisallowedEarlyExitReferences() {
        return this.disallowedEarylExitReferences;
    }

    @Check
    public void checkInvalidReturnExpression(XExpression expression) {
        EReference contFeature = (EReference)expression.eContainingFeature();
        Map<EReference, EarlyExitKind> map = this.getDisallowedEarlyExitReferences();
        if (map.containsKey(contFeature)) {
            EarlyExitKind exitKind = map.get(contFeature);
            ArrayList returns = Lists.newArrayList();
            this.collectExits(expression, returns);
            for (XExpression expr : returns) {
                if (expr instanceof XReturnExpression && (exitKind == EarlyExitKind.RETURN || exitKind == EarlyExitKind.BOTH)) {
                    this.error("A return expression is not allowed in this context.", expr, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_early_exit", new String[0]);
                }
                if (!(expr instanceof XThrowExpression) || exitKind != EarlyExitKind.THROW && exitKind != EarlyExitKind.BOTH) continue;
                this.error("A throw expression is not allowed in this context.", expr, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_early_exit", new String[0]);
            }
        }
    }

    protected void collectExits(EObject expr, List<XExpression> found) {
        if (expr instanceof XReturnExpression) {
            found.add((XExpression)expr);
        } else if (expr instanceof XThrowExpression) {
            found.add((XExpression)expr);
        } else if (expr instanceof XClosure) {
            return;
        }
        for (EObject child : expr.eContents()) {
            this.collectExits(child, found);
        }
    }

    @Check
    public void checkDeadCode(XBlockExpression block) {
        EList<XExpression> expressions = block.getExpressions();
        int i = 0;
        int size = expressions.size();
        while (i < size - 1) {
            XExpression expression = (XExpression)expressions.get(i);
            if (this.earlyExitComputer.isEarlyExit(expression)) {
                if (!(expression instanceof XAbstractFeatureCall)) {
                    this.markAsDeadCode((XExpression)expressions.get(i + 1));
                }
                return;
            }
            ++i;
        }
    }

    @Check
    public void checkDeadCode(XWhileExpression loop) {
        XExpression predicate = loop.getPredicate();
        if (!this.earlyExitComputer.isEarlyExit(predicate)) {
            Optional<BooleanResult> result = this.getBooleanResult(predicate);
            if (result.isPresent()) {
                BooleanResult booleanResult = (BooleanResult)result.get();
                this.markConstantBooleanCondition(predicate, booleanResult, true);
                if (booleanResult.isCompileTimeConstant() && !((Boolean)booleanResult.getValue().or((Object)Boolean.TRUE)).booleanValue()) {
                    this.markAsDeadCode(loop.getBody());
                }
            }
        } else {
            this.markAsDeadCode(loop.getBody());
        }
    }

    protected void markConstantBooleanCondition(XExpression predicate, BooleanResult booleanResult, boolean ignoreBooleanLiteral) {
        if (!ignoreBooleanLiteral || predicate.eClass() != XbasePackage.Literals.XBOOLEAN_LITERAL) {
            Optional<Boolean> value = booleanResult.getValue();
            if (value.isPresent()) {
                this.addIssue("Constant condition is always " + String.valueOf(value.get()) + ".", predicate, null, "org.eclipse.xtext.xbase.validation.IssueCodes.constant_condition", new String[0]);
            } else {
                this.addIssue("Constant condition.", predicate, null, "org.eclipse.xtext.xbase.validation.IssueCodes.constant_condition", new String[0]);
            }
        }
    }

    private boolean markAsDeadCode(List<XExpression> expressions) {
        if (!expressions.isEmpty()) {
            this.markAsDeadCode(expressions.get(0));
            return true;
        }
        return false;
    }

    private void validateCondition(XExpression expression, boolean ignoreBooleanLiteral) {
        Optional<BooleanResult> result;
        if (!this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.constant_condition") && (result = this.getBooleanResult(expression)).isPresent()) {
            this.markConstantBooleanCondition(expression, (BooleanResult)result.get(), ignoreBooleanLiteral);
        }
    }

    private boolean markAsDeadCode(XExpression expression) {
        EList<XExpression> expressions;
        if (expression instanceof XBlockExpression && this.markAsDeadCode((List<XExpression>)(expressions = ((XBlockExpression)expression).getExpressions()))) {
            return true;
        }
        if (expression != null) {
            this.error("Unreachable expression.", expression, null, "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_code", new String[0]);
            return true;
        }
        return false;
    }

    private boolean markAsDeadCode(JvmTypeReference typeGuard) {
        if (typeGuard != null) {
            this.error("Unreachable expression.", (EObject)typeGuard, null, "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_code", new String[0]);
            return true;
        }
        return false;
    }

    @Check
    public void checkDeadCode(XDoWhileExpression loop) {
        if (this.earlyExitComputer.isEarlyExit(loop.getBody())) {
            this.markAsDeadCode(loop.getPredicate());
        } else {
            XExpression predicate = loop.getPredicate();
            if (!this.earlyExitComputer.isEarlyExit(predicate)) {
                this.validateCondition(predicate, true);
            }
        }
    }

    @Check
    public void checkDeadCode(XIfExpression condition) {
        if (!this.earlyExitComputer.isEarlyExit(condition.getIf())) {
            this.validateCondition(condition.getIf(), false);
        } else if (!this.markAsDeadCode(condition.getThen())) {
            this.markAsDeadCode(condition.getElse());
        }
    }

    @Check
    public void checkDeadCode(XBasicForLoopExpression loop) {
        XExpression predicate = loop.getExpression();
        if (!this.earlyExitComputer.isEarlyExit(predicate)) {
            Optional<BooleanResult> result = this.getBooleanResult(predicate);
            if (result.isPresent()) {
                BooleanResult booleanResult = (BooleanResult)result.get();
                this.markConstantBooleanCondition(predicate, booleanResult, false);
                if (booleanResult.isCompileTimeConstant() && !((Boolean)booleanResult.getValue().or((Object)Boolean.TRUE)).booleanValue()) {
                    this.markAsDeadCode(loop.getEachExpression());
                    return;
                }
            }
            if (this.earlyExitComputer.isEarlyExit(loop.getEachExpression())) {
                this.markAsDeadCode((List<XExpression>)loop.getUpdateExpressions());
            }
        } else if (!this.markAsDeadCode((List<XExpression>)loop.getUpdateExpressions())) {
            this.markAsDeadCode(loop.getEachExpression());
        }
    }

    protected Optional<BooleanResult> getBooleanResult(XExpression expression) {
        if (expression == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)this.constantExpressionInterpreter.getBooleanConstantOrNull(expression));
    }

    @Check
    public void checkDeadCode(XSwitchExpression switchExpression) {
        EList<XCasePart> cases = switchExpression.getCases();
        int i = 0;
        int size = cases.size();
        while (i < size) {
            XCasePart casePart = (XCasePart)cases.get(i);
            XExpression caseExpression = casePart.getCase();
            if (!this.earlyExitComputer.isEarlyExit(caseExpression)) {
                this.validateCondition(caseExpression, false);
            } else if (!this.markAsDeadCode(casePart.getThen()) && casePart.getTypeGuard() == null) {
                i = this.markAsDeadCode((List<XCasePart>)cases, casePart, i, size);
            }
            ++i;
        }
    }

    protected int markAsDeadCode(List<XCasePart> cases, XCasePart from, int idx, int size) {
        if (!this.markAsDeadCode(from.getThen())) {
            int j = idx + 1;
            while (j < size) {
                XCasePart next = cases.get(j);
                if (this.markAsDeadCode(next.getTypeGuard()) || this.markAsDeadCode(next.getCase()) || this.markAsDeadCode(next.getThen())) {
                    idx = j;
                    j = size;
                }
                ++j;
            }
        }
        return idx;
    }

    public void register(EValidatorRegistrar registrar) {
    }

    protected static enum EarlyExitKind {
        RETURN,
        THROW,
        BOTH;

    }
}

