/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.detachable;

import java.io.IOException;
import java.lang.ref.SoftReference;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.detachable.AbstractDetachableParseResult;
import org.eclipse.xtext.nodemodel.detachable.NodeModelReference;

public class OffloadedNodeModelReference<Serialized>
extends NodeModelReference {
    private static final Logger logger = Logger.getLogger(OffloadedNodeModelReference.class);
    protected SoftReference<NodeModelReference> cached;
    protected Serialized serialized;
    protected final AbstractDetachableParseResult<?, Serialized> parseResult;

    public OffloadedNodeModelReference(AbstractDetachableParseResult<?, Serialized> parseResult, Serialized serialized) {
        this.parseResult = parseResult;
        this.serialized = serialized;
        this.cached = new SoftReference<Object>(null);
    }

    @Override
    protected ICompositeNode rootNode() {
        return this.delegate().rootNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeModelReference delegate() {
        this.parseResult.nodeModelRequested();
        NodeModelReference result = this.cached.get();
        if (result != null) {
            return result;
        }
        try {
            OffloadedNodeModelReference offloadedNodeModelReference = this;
            synchronized (offloadedNodeModelReference) {
                result = this.cached.get();
                if (result != null) {
                    return result;
                }
                result = this.parseResult.deserialize(this.serialized);
                this.cached = new SoftReference<NodeModelReference>(result);
                this.parseResult.scheduleRelease();
                return result;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void release() {
        logger.trace((Object)"OffloadedNodeModelReference.release");
        this.cached = new SoftReference<Object>(null);
    }

    @Override
    protected ICompositeNode getNode(EObject semanticObject) {
        return this.delegate().getNode(semanticObject);
    }

    @Override
    protected INode getNode(int id) {
        return this.delegate().getNode(id);
    }

    @Override
    protected int getId(INode node) {
        return this.delegate().getId(node);
    }
}

