/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class FileSelectionUtil {
    private FileSelectionUtil() {
    }

    public static String browseForFileInWorkspace(Shell parent, String[] ext) {
        List<String> r = FileSelectionUtil.browseForFilesInWorkspace(parent, ext, false);
        if (r == null || r.isEmpty()) {
            return null;
        }
        return r.get(0);
    }

    public static List<String> browseForFilesInWorkspace(Shell parent, String[] ext) {
        return FileSelectionUtil.browseForFilesInWorkspace(parent, ext, true);
    }

    private static List<String> browseForFilesInWorkspace(Shell parent, final String[] ext, boolean allowMultiple) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(parent, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle("Select file");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setAllowMultiple(allowMultiple);
        if (ext != null && ext.length > 0) {
            dialog.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parent, Object element) {
                    if (element instanceof IFile) {
                        IFile f = (IFile)element;
                        String[] stringArray = ext;
                        int n = ext.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String extension = stringArray[n2];
                            if (f.getName().endsWith(extension)) {
                                return true;
                            }
                            ++n2;
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        if (dialog.open() == 0) {
            ArrayList<String> result = new ArrayList<String>();
            Object[] objectArray = dialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object r = objectArray[n2];
                IResource resource = (IResource)r;
                result.add(resource.getLocation().toString());
                ++n2;
            }
            return result;
        }
        return null;
    }

    public static String browseForFile(Shell parent, String[] ext) {
        File workspaceDir = new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
        FileDialog fd = new FileDialog(parent, 4096);
        fd.setText("Browse");
        if (ext != null && ext.length > 0) {
            String[] filter = new String[ext.length];
            int i = 0;
            while (i < ext.length) {
                filter[i] = "*" + ext[i];
                ++i;
            }
            fd.setFilterExtensions(filter);
        }
        fd.setFilterPath(workspaceDir.getAbsolutePath());
        return fd.open();
    }

    public static String browseForDir(Shell parent) {
        File workspaceDir = new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
        DirectoryDialog fd = new DirectoryDialog(parent, 4096);
        fd.setText("Browse");
        fd.setFilterPath(workspaceDir.getAbsolutePath());
        return fd.open();
    }
}

