/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.core.io.conv;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum DependencyType {
    SOURCE_STOP2_SINK_START(0, "SourceStop2SinkStart", "SourceStop2SinkStart"),
    SOURCE_STOP2_SINK_STOP(1, "SourceStop2SinkStop", "SourceStop2SinkStop"),
    SOURCE_START2_SINK_START(2, "SourceStart2SinkStart", "SourceStart2SinkStart"),
    SOURCE_START2_SINK_STOP(3, "SourceStart2SinkStop", "SourceStart2SinkStop");

    public static final int SOURCE_STOP2_SINK_START_VALUE = 0;
    public static final int SOURCE_STOP2_SINK_STOP_VALUE = 1;
    public static final int SOURCE_START2_SINK_START_VALUE = 2;
    public static final int SOURCE_START2_SINK_STOP_VALUE = 3;
    private static final DependencyType[] VALUES_ARRAY;
    public static final List<DependencyType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DependencyType[]{SOURCE_STOP2_SINK_START, SOURCE_STOP2_SINK_STOP, SOURCE_START2_SINK_START, SOURCE_START2_SINK_STOP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DependencyType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DependencyType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DependencyType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DependencyType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DependencyType get(int value) {
        switch (value) {
            case 0: {
                return SOURCE_STOP2_SINK_START;
            }
            case 1: {
                return SOURCE_STOP2_SINK_STOP;
            }
            case 2: {
                return SOURCE_START2_SINK_START;
            }
            case 3: {
                return SOURCE_START2_SINK_STOP;
            }
        }
        return null;
    }

    private DependencyType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

