/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.contentassist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.internal.text.InformationControlReplacer;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.JFaceTextMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

class AdditionalInfoController
extends AbstractInformationControlManager {
    private volatile Table fProposalTable;
    private SelectionListener fSelectionListener = new TableSelectionListener();
    private final int fDelay;
    private volatile Timer fTimer;
    private volatile ICompletionProposal fProposal;
    private Object fInformation;

    AdditionalInfoController(IInformationControlCreator creator, int delay) {
        super(creator);
        this.fDelay = delay;
        this.setAnchor(ANCHOR_RIGHT);
        this.setFallbackAnchors(new AbstractInformationControlManager.Anchor[]{ANCHOR_RIGHT, ANCHOR_LEFT, ANCHOR_BOTTOM});
        int spacing = -1;
        this.setMargins(spacing, spacing);
        InformationControlReplacer replacer = new InformationControlReplacer(new DefaultPresenterControlCreator());
        this.getInternalAccessor().setInformationControlReplacer(replacer);
    }

    @Override
    public void install(Control control) {
        if (this.fProposalTable == control) {
            return;
        }
        Assert.isTrue((boolean)(control instanceof Table));
        super.install((Control)control.getShell());
        this.fProposalTable = (Table)control;
        ((Table)control).addSelectionListener(this.fSelectionListener);
        this.getInternalAccessor().getInformationControlReplacer().install(control);
        this.fTimer = new Timer(control.getDisplay(), this.fDelay){

            @Override
            protected void showInformation(ICompletionProposal proposal, Object info) {
                InformationControlReplacer replacer = AdditionalInfoController.this.getInternalAccessor().getInformationControlReplacer();
                if (replacer != null) {
                    replacer.hideInformationControl();
                }
                AdditionalInfoController.this.showInformation(proposal, info);
            }
        };
    }

    @Override
    public void disposeInformationControl() {
        Table table;
        Timer timer = this.fTimer;
        if (timer != null) {
            timer.terminate();
            this.fTimer = null;
        }
        if ((table = this.fProposalTable) != null && !table.isDisposed()) {
            table.removeSelectionListener(this.fSelectionListener);
            this.fProposalTable = null;
        }
        this.fProposal = null;
        this.fInformation = null;
        super.disposeInformationControl();
    }

    public void handleTableSelectionChanged() {
        TableItem item;
        Object d;
        TableItem[] selection;
        Table table = this.fProposalTable;
        if (table != null && !table.isDisposed() && table.isVisible() && (selection = table.getSelection()) != null && selection.length > 0 && (d = (item = selection[0]).getData()) instanceof ICompletionProposal) {
            ICompletionProposal p = (ICompletionProposal)d;
            Timer timer = this.fTimer;
            if (timer != null) {
                timer.reset(p);
            }
        }
    }

    void showInformation(ICompletionProposal proposal, Object info) {
        ICompletionProposal oldProposal = this.fProposal;
        Object oldInformation = this.fInformation;
        Table table = this.fProposalTable;
        if (table == null || table.isDisposed()) {
            return;
        }
        if (oldProposal == proposal && (info == null && oldInformation == null || info != null && info.equals(oldInformation))) {
            return;
        }
        this.fInformation = info;
        this.fProposal = proposal;
        this.showInformation();
    }

    @Override
    protected void computeInformation() {
        Table table = this.fProposalTable;
        if (table == null || table.isDisposed()) {
            return;
        }
        ICompletionProposal proposal = this.fProposal;
        if (proposal instanceof ICompletionProposalExtension3) {
            this.setCustomInformationControlCreator(((ICompletionProposalExtension3)((Object)proposal)).getInformationControlCreator());
        } else {
            this.setCustomInformationControlCreator(null);
        }
        table = this.fProposalTable;
        if (table == null || table.isDisposed()) {
            return;
        }
        Point size = table.getShell().getSize();
        this.setInformation(this.fInformation, new Rectangle(0, 0, size.x, size.y));
    }

    @Override
    protected Point computeLocation(Rectangle subjectArea, Point controlSize, AbstractInformationControlManager.Anchor anchor) {
        Point location = super.computeLocation(subjectArea, controlSize, anchor);
        Table table = this.fProposalTable;
        if (table == null) {
            return location;
        }
        Rectangle trim = table.getShell().computeTrim(0, 0, 0, 0);
        location.x += trim.x;
        location.y += trim.y;
        return location;
    }

    @Override
    protected Point computeSizeConstraints(Control subjectControl, IInformationControl informationControl) {
        Point sizeConstraint = super.computeSizeConstraints(subjectControl, informationControl);
        Point size = subjectControl.getShell().getSize();
        if (this.fInformationControl instanceof IInformationControlExtension3) {
            Rectangle shellTrim = ((IInformationControlExtension3)((Object)this.fInformationControl)).computeTrim();
            size.x -= shellTrim.width;
            size.y -= shellTrim.height;
        }
        if (sizeConstraint.x < size.x) {
            sizeConstraint.x = size.x;
        }
        if (sizeConstraint.y < size.y) {
            sizeConstraint.y = size.y;
        }
        return sizeConstraint;
    }

    @Override
    protected void hideInformationControl() {
        super.hideInformationControl();
        Timer timer = this.fTimer;
        if (timer != null) {
            timer.reset(null);
        }
    }

    @Override
    protected boolean canClearDataOnHide() {
        return false;
    }

    public IInformationControl getCurrentInformationControl2() {
        return this.getInternalAccessor().getCurrentInformationControl();
    }

    private static class DefaultPresenterControlCreator
    extends AbstractReusableInformationControlCreator {
        private DefaultPresenterControlCreator() {
        }

        @Override
        public IInformationControl doCreateInformationControl(Shell shell) {
            return new DefaultInformationControl(shell, true);
        }
    }

    private class TableSelectionListener
    implements SelectionListener {
        private TableSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            AdditionalInfoController.this.handleTableSelectionChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private static abstract class Timer {
        private static final int DELAY_UNTIL_JOB_IS_SCHEDULED = 50;
        private final Task IDLE = new Task(this){

            @Override
            public void run() {
                Assert.isTrue((boolean)false);
            }

            @Override
            public Task nextTask() {
                Assert.isTrue((boolean)false);
                return null;
            }

            @Override
            public long delay() {
                return Long.MAX_VALUE;
            }

            public String toString() {
                return "IDLE";
            }
        };
        private final Task FIRST_WAIT = new Task(this){

            @Override
            public void run() {
                final ICompletionProposalExtension5 proposal = this.getCurrentProposalEx();
                Job job = new Job(JFaceTextMessages.getString("AdditionalInfoController.job_name")){

                    protected IStatus run(IProgressMonitor monitor) {
                        Object info;
                        try {
                            info = proposal.getAdditionalProposalInfo(monitor);
                        }
                        catch (RuntimeException x) {
                            return new Status(2, "org.eclipse.jface.text", 0, "", (Throwable)x);
                        }
                        this.setInfo((ICompletionProposal)((Object)proposal), info);
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }

            @Override
            public Task nextTask() {
                return SECOND_WAIT;
            }

            @Override
            public long delay() {
                return 50L;
            }

            public String toString() {
                return "FIRST_WAIT";
            }
        };
        private final Task SECOND_WAIT = new Task(this){

            @Override
            public void run() {
                this.allowShowing();
            }

            @Override
            public Task nextTask() {
                return IDLE;
            }

            @Override
            public long delay() {
                return fDelay - 50;
            }

            public String toString() {
                return "SECOND_WAIT";
            }
        };
        private final Task LEGACY_WAIT = new Task(this){

            @Override
            public void run() {
                ICompletionProposal proposal = this.getCurrentProposal();
                if (!fDisplay.isDisposed()) {
                    fDisplay.asyncExec(() -> {
                        Timer timer = this;
                        synchronized (timer) {
                            if (proposal == this.getCurrentProposal()) {
                                String info = proposal.getAdditionalProposalInfo();
                                this.showInformation(proposal, info);
                            }
                        }
                    });
                }
            }

            @Override
            public Task nextTask() {
                return IDLE;
            }

            @Override
            public long delay() {
                return fDelay;
            }

            public String toString() {
                return "LEGACY_WAIT";
            }
        };
        private final Task EXIT = new Task(this){

            @Override
            public long delay() {
                return 1L;
            }

            @Override
            public Task nextTask() {
                Assert.isTrue((boolean)false);
                return EXIT;
            }

            @Override
            public void run() {
                Assert.isTrue((boolean)false);
            }

            public String toString() {
                return "EXIT";
            }
        };
        private final Thread fThread;
        private Task fTask;
        private long fNextWakeup;
        private ICompletionProposal fCurrentProposal = null;
        private Object fCurrentInfo = null;
        private boolean fAllowShowing = false;
        private final Display fDisplay;
        private final int fDelay;

        public Timer(Display display, int delay) {
            this.fDisplay = display;
            this.fDelay = delay;
            long current = System.currentTimeMillis();
            this.schedule(this.IDLE, current);
            this.fThread = new Thread(() -> {
                try {
                    this.loop();
                }
                catch (InterruptedException interruptedException) {}
            }, JFaceTextMessages.getString("InfoPopup.info_delay_timer_name"));
            this.fThread.start();
        }

        public final synchronized void terminate() {
            this.schedule(this.EXIT, System.currentTimeMillis());
            this.notifyAll();
        }

        public final synchronized void reset(ICompletionProposal p) {
            if (this.fCurrentProposal != p) {
                this.fCurrentProposal = p;
                this.fCurrentInfo = null;
                this.fAllowShowing = false;
                long oldWakeup = this.fNextWakeup;
                Task task = this.taskOnReset(p);
                this.schedule(task, System.currentTimeMillis());
                if (this.fNextWakeup < oldWakeup) {
                    this.notifyAll();
                }
            }
        }

        private Task taskOnReset(ICompletionProposal p) {
            if (p == null) {
                return this.IDLE;
            }
            if (this.isExt5(p)) {
                return this.FIRST_WAIT;
            }
            return this.LEGACY_WAIT;
        }

        private synchronized void loop() throws InterruptedException {
            long current = System.currentTimeMillis();
            Task task = this.currentTask();
            while (task != this.EXIT) {
                long delay = this.fNextWakeup - current;
                if (delay <= 0L) {
                    task.run();
                    task = task.nextTask();
                    this.schedule(task, current);
                    continue;
                }
                this.wait(delay);
                current = System.currentTimeMillis();
                task = this.currentTask();
            }
        }

        private Task currentTask() {
            return this.fTask;
        }

        private void schedule(Task task, long current) {
            this.fTask = task;
            long nextWakeup = current + task.delay();
            this.fNextWakeup = nextWakeup <= current ? Long.MAX_VALUE : nextWakeup;
        }

        private boolean isExt5(ICompletionProposal p) {
            return p instanceof ICompletionProposalExtension5;
        }

        ICompletionProposal getCurrentProposal() {
            return this.fCurrentProposal;
        }

        ICompletionProposalExtension5 getCurrentProposalEx() {
            Assert.isTrue((boolean)(this.fCurrentProposal instanceof ICompletionProposalExtension5));
            return (ICompletionProposalExtension5)((Object)this.fCurrentProposal);
        }

        synchronized void setInfo(ICompletionProposal proposal, Object info) {
            if (proposal == this.fCurrentProposal) {
                this.fCurrentInfo = info;
                if (this.fAllowShowing) {
                    this.triggerShowing();
                }
            }
        }

        private void triggerShowing() {
            Object info = this.fCurrentInfo;
            if (!this.fDisplay.isDisposed()) {
                this.fDisplay.asyncExec(() -> {
                    Timer timer = this;
                    synchronized (timer) {
                        if (info == this.fCurrentInfo) {
                            this.showInformation(this.fCurrentProposal, info);
                        }
                    }
                });
            }
        }

        protected abstract void showInformation(ICompletionProposal var1, Object var2);

        void allowShowing() {
            this.fAllowShowing = true;
            this.triggerShowing();
        }

        private abstract class Task
        implements Runnable {
            private Task() {
            }

            public abstract long delay();

            @Override
            public abstract void run();

            public abstract Task nextTask();
        }
    }
}

