/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers;

import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.RocmEventLayout;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.IRocmEventHandler;
import org.eclipse.tracecompass.incubator.rocm.core.ctfplugin.trace.RocmCtfPluginTrace;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class ApiEventHandler
implements IRocmEventHandler {
    private static final String HIP = "HIP";
    private static final String HSA = "HSA";
    private boolean fIsThreadIdProvidedHSA = false;
    private boolean fIsThreadIdProvidedHIP = false;

    private static void provideThreadId(ITmfEvent event, ITmfStateSystemBuilder ssb, int quark, RocmEventLayout layout) {
        Integer tid = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{layout.fieldThreadId()});
        ssb.modifyAttribute(event.getTimestamp().getValue(), (Object)tid, quark);
    }

    @Override
    public void handleEvent(ITmfEvent event, ITmfStateSystemBuilder ssb, RocmEventLayout layout) {
        int apiQuark;
        Integer tid = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{layout.fieldThreadId()});
        if (tid == null) {
            return;
        }
        int rootQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"root", "Processes"});
        int processQuark = ssb.getQuarkRelativeAndAdd(rootQuark, new String[]{tid.toString()});
        ApiEventHandler.addEventToOperationQueue(event, ssb, layout);
        boolean isEndEvent = false;
        int callStackQuark = -2;
        if (event.getName().startsWith(layout.getHipPrefix())) {
            apiQuark = ssb.getQuarkRelativeAndAdd(processQuark, new String[]{HIP});
            callStackQuark = ssb.getQuarkRelativeAndAdd(apiQuark, new String[]{"CallStack"});
            isEndEvent = event.getName().endsWith(layout.getHipEndSuffix());
            if (!this.fIsThreadIdProvidedHIP) {
                ApiEventHandler.provideThreadId(event, ssb, processQuark, layout);
                ApiEventHandler.provideThreadId(event, ssb, apiQuark, layout);
                this.fIsThreadIdProvidedHIP = true;
            }
        } else if (event.getName().startsWith(layout.getHsaPrefix())) {
            if (event.getName().equals(layout.getHsaHandleType())) {
                return;
            }
            apiQuark = ssb.getQuarkRelativeAndAdd(processQuark, new String[]{HSA});
            callStackQuark = ssb.getQuarkRelativeAndAdd(apiQuark, new String[]{"CallStack"});
            isEndEvent = event.getName().endsWith(layout.getHsaEndSuffix());
            if (!this.fIsThreadIdProvidedHSA) {
                ApiEventHandler.provideThreadId(event, ssb, processQuark, layout);
                ApiEventHandler.provideThreadId(event, ssb, apiQuark, layout);
                this.fIsThreadIdProvidedHSA = true;
            }
        }
        if (isEndEvent) {
            ssb.popAttribute(event.getTimestamp().getValue(), callStackQuark);
            return;
        }
        String eventName = event.getName().startsWith(layout.getHipPrefix()) ? event.getName().substring(0, event.getName().length() - layout.getHipBeginSuffix().length()) : event.getName().substring(0, event.getName().length() - layout.getHsaBeginSuffix().length());
        ssb.pushAttribute(event.getTimestamp().getValue(), (Object)eventName, callStackQuark);
    }

    private static void addEventToOperationQueue(ITmfEvent event, ITmfStateSystemBuilder ssb, RocmEventLayout layout) {
        int nameQuark;
        int subQuark;
        int depth;
        Long correlationId = (Long)event.getContent().getFieldValue(Long.class, new String[]{layout.fieldCorrelationId()});
        if (correlationId == null) {
            return;
        }
        int operationsQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"hip_operation_queues"});
        long ts = event.getTimestamp().getValue();
        if (layout.isMemcpyBegin(event.getName()) || event.getName().equals(layout.hipLaunchKernelBegin()) && ((RocmCtfPluginTrace)event.getTrace()).isContainingKernelGpuActivity() || event.getName().equals(layout.hipStreamSynchronizeBegin())) {
            depth = 1;
            subQuark = ssb.getQuarkRelativeAndAdd(operationsQuark, new String[]{String.valueOf(depth)});
            while (!ssb.queryOngoingState(subQuark).isNull()) {
                subQuark = ssb.getQuarkRelativeAndAdd(operationsQuark, new String[]{String.valueOf(++depth)});
            }
            ssb.modifyAttribute(ts, (Object)correlationId, subQuark);
            nameQuark = ssb.getQuarkRelativeAndAdd(subQuark, new String[]{"name"});
            if (layout.isMemcpyBegin(event.getName())) {
                ssb.modifyAttribute(ts, event.getContent().getFieldValue(String.class, new String[]{layout.fieldMemcpyKind()}), nameQuark);
            } else if (event.getName().equals(layout.hipLaunchKernelBegin())) {
                ssb.modifyAttribute(ts, event.getContent().getFieldValue(String.class, new String[]{layout.fieldKernelName()}), nameQuark);
            } else if (event.getName().equals(layout.hipStreamSynchronizeBegin())) {
                ssb.modifyAttribute(ts, (Object)event.getName().substring(0, event.getName().length() - layout.getHipBeginSuffix().length()), nameQuark);
            }
        }
        if (event.getName().equals(layout.hipStreamSynchronizeEnd())) {
            depth = 1;
            try {
                subQuark = ssb.getQuarkRelative(operationsQuark, new String[]{String.valueOf(depth)});
                while (correlationId.longValue() != ssb.queryOngoingState(subQuark).unboxLong()) {
                    if ((subQuark = ssb.optQuarkRelative(operationsQuark, new String[]{String.valueOf(++depth)})) != -2) continue;
                    return;
                }
                ssb.modifyAttribute(ts, null, subQuark);
                nameQuark = ssb.getQuarkRelative(subQuark, new String[]{"name"});
                ssb.modifyAttribute(ts, null, nameQuark);
            }
            catch (AttributeNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

