/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.cpu;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.ust.core.trace.ContextVtidAspect;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;

public class UstCpuStateProvider
extends AbstractTmfStateProvider {
    public static final @NonNull String ID = "org.eclipse.linuxtools.lttng2.ust.analysis.cpu.stateprovider";
    public static final String THREADS = "Threads";

    public UstCpuStateProvider(@NonNull ITmfTrace trace) {
        super(trace, ID);
    }

    public int getVersion() {
        return 0;
    }

    public @NonNull ITmfStateProvider getNewInstance() {
        return new UstCpuStateProvider(this.getTrace());
    }

    protected void eventHandle(@NonNull ITmfEvent event) {
        ITmfStateSystemBuilder ssb = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
        CtfTmfEvent ctfEvent = (CtfTmfEvent)event;
        int cpuId = ctfEvent.getCPU();
        Object vtid = TmfTraceUtils.resolveEventAspectOfClassForEvent((ITmfTrace)this.getTrace(), ContextVtidAspect.class, (ITmfEvent)event);
        if (vtid != null) {
            int threadQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{THREADS, vtid.toString()});
            ssb.modifyAttribute(event.getTimestamp().getValue(), (Object)cpuId, threadQuark);
        }
    }
}

