/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.resources.IPathEntryVariableChangeListener;
import org.eclipse.cdt.core.resources.IPathEntryVariableManager;
import org.eclipse.cdt.core.resources.PathEntryVariableChangeEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.cdtvariables.ICdtVariableChangeListener;
import org.eclipse.cdt.internal.core.cdtvariables.UserDefinedVariableSupplier;
import org.eclipse.cdt.internal.core.cdtvariables.VariableChangeEvent;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.cdt.utils.cdtvariables.ICdtVariableSupplier;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableSubstitutor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;

public class CdtVarPathEntryVariableManager
implements IPathEntryVariableManager,
ICdtVariableChangeListener {
    private UserDefinedVariableSupplier fUserVarSupplier = UserDefinedVariableSupplier.getInstance();
    private VarSubstitutor fSubstitutor = new VarSubstitutor();
    private VarSupplier fVarSupplier = new VarSupplier();
    private Set<IPathEntryVariableChangeListener> fListeners = Collections.synchronizedSet(new HashSet());

    public CdtVarPathEntryVariableManager() {
        this.fUserVarSupplier.addListener(this);
    }

    @Override
    public IPath getValue(String name) {
        ICdtVariable var = this.fUserVarSupplier.getMacro(name, 5, null);
        return CdtVarPathEntryVariableManager.getVariablePath(var);
    }

    public static IPath getVariablePath(ICdtVariable var) {
        if (var != null) {
            switch (var.getValueType()) {
                case 3: 
                case 5: 
                case 7: {
                    try {
                        String value = var.getStringValue();
                        if (value != null) {
                            return new Path(value);
                        }
                        return Path.EMPTY;
                    }
                    catch (CdtVariableException e) {
                        CCorePlugin.log((Throwable)((Object)e));
                    }
                }
            }
        }
        return null;
    }

    public static boolean isPathEntryVariable(ICdtVariable var, ICConfigurationDescription cfg) {
        return CdtVarPathEntryVariableManager.isPathEntryVariable(var, cfg, CCorePlugin.getDefault().getCdtVariableManager());
    }

    public static boolean isPathEntryVariable(ICdtVariable var, ICConfigurationDescription cfg, ICdtVariableManager mngr) {
        if (mngr.isUserVariable(var, cfg)) {
            return false;
        }
        if (!mngr.isUserVariable(var, null)) {
            return false;
        }
        return CdtVarPathEntryVariableManager.getVariablePath(var) != null;
    }

    @Override
    public String[] getVariableNames() {
        ICdtVariable[] vars = this.fUserVarSupplier.getMacros(5, null);
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i > vars.length) {
            if (CdtVarPathEntryVariableManager.getVariablePath(vars[i]) != null) {
                list.add(vars[i].getName());
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public boolean isDefined(String name) {
        return this.getValue(name) != null;
    }

    @Override
    public IPath resolvePath(IPath path) {
        if (path == null) {
            return null;
        }
        String str = path.toPortableString();
        try {
            str = CdtVariableResolver.resolveToString(str, this.fSubstitutor);
        }
        catch (CdtVariableException e) {
            CCorePlugin.log((Throwable)((Object)e));
        }
        return new Path(str);
    }

    @Override
    public void setValue(String name, IPath value) throws CoreException {
        if (value != null) {
            this.fUserVarSupplier.createMacro(name, 7, value.toString(), 5, null);
        } else {
            this.fUserVarSupplier.deleteMacro(name, 5, null);
        }
        this.fUserVarSupplier.storeWorkspaceVariables(false);
    }

    private void fireVariableChangeEvent(String name, IPath value, int type) {
        if (this.fListeners.size() == 0) {
            return;
        }
        Object[] listenerArray = this.fListeners.toArray();
        final PathEntryVariableChangeEvent pve = new PathEntryVariableChangeEvent(this, name, value, type);
        int i = 0;
        while (i < listenerArray.length) {
            final IPathEntryVariableChangeListener l = (IPathEntryVariableChangeListener)listenerArray[i];
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    l.pathVariableChanged(pve);
                }
            };
            SafeRunner.run((ISafeRunnable)job);
            ++i;
        }
    }

    @Override
    public void addChangeListener(IPathEntryVariableChangeListener listener) {
        this.fListeners.add(listener);
    }

    @Override
    public void removeChangeListener(IPathEntryVariableChangeListener listener) {
        this.fListeners.remove(listener);
    }

    @Override
    public void variablesChanged(VariableChangeEvent event) {
        ICdtVariable[] added = event.getAddedVariables();
        ICdtVariable[] removed = event.getRemovedVariables();
        ICdtVariable[] changed = event.getChangedVariables();
        if (added.length != 0) {
            this.fireEvent(added, 2);
        }
        if (removed.length != 0) {
            this.fireEvent(removed, 3);
        }
        if (changed.length != 0) {
            this.fireEvent(changed, 1);
        }
    }

    private void fireEvent(ICdtVariable[] vars, int type) {
        ICdtVariable[] iCdtVariableArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            ICdtVariable var = iCdtVariableArray[n2];
            IPath path = CdtVarPathEntryVariableManager.getVariablePath(var);
            if (path != null) {
                this.fireVariableChangeEvent(var.getName(), path, type);
            }
            ++n2;
        }
    }

    public void startup() {
    }

    public void shutdown() {
    }

    private class VarContextInfo
    implements IVariableContextInfo {
        private VarContextInfo() {
        }

        @Override
        public IVariableContextInfo getNext() {
            return null;
        }

        @Override
        public ICdtVariableSupplier[] getSuppliers() {
            return new ICdtVariableSupplier[]{CdtVarPathEntryVariableManager.this.fVarSupplier};
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof VarContextInfo;
        }
    }

    private class VarSubstitutor
    extends SupplierBasedCdtVariableSubstitutor {
        public VarSubstitutor() {
            super(new VarContextInfo(), "", " ");
        }
    }

    private class VarSupplier
    implements ICdtVariableSupplier {
        private VarSupplier() {
        }

        @Override
        public ICdtVariable getVariable(String macroName, IVariableContextInfo context) {
            ICdtVariable var = CdtVarPathEntryVariableManager.this.fUserVarSupplier.getMacro(macroName, 5, null);
            if (var != null && CdtVarPathEntryVariableManager.getVariablePath(var) != null) {
                return var;
            }
            return null;
        }

        @Override
        public ICdtVariable[] getVariables(IVariableContextInfo context) {
            ICdtVariable[] vars = CdtVarPathEntryVariableManager.this.fUserVarSupplier.getMacros(5, null);
            ArrayList<ICdtVariable> list = new ArrayList<ICdtVariable>();
            ICdtVariable[] iCdtVariableArray = vars;
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                ICdtVariable var = iCdtVariableArray[n2];
                if (CdtVarPathEntryVariableManager.getVariablePath(var) != null) {
                    list.add(var);
                }
                ++n2;
            }
            return list.toArray(new ICdtVariable[list.size()]);
        }
    }
}

