/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.search;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.common.core.search.pattern.QualifiedName;
import org.eclipse.wst.xml.core.internal.search.XMLSearchPattern;

public abstract class ComponentSearchContributor {
    protected HashMap declarations;
    protected HashMap references;
    protected String[] namespaces;

    public XMLSearchPattern getDeclarationPattern(QualifiedName componentName) {
        return (XMLSearchPattern)((Object)this.getDeclarations().get(componentName));
    }

    protected Map getDeclarations() {
        if (this.declarations == null) {
            this.initializeDeclarations();
        }
        return this.declarations;
    }

    protected Map getReferences() {
        if (this.references == null) {
            this.initializeReferences();
        }
        return this.references;
    }

    public XMLSearchPattern[] getReferencesPatterns(QualifiedName componentName) {
        List references = (List)this.getReferences().get(componentName);
        if (references != null) {
            return references.toArray(new XMLSearchPattern[references.size()]);
        }
        return new XMLSearchPattern[0];
    }

    public boolean supports(QualifiedName componentName) {
        return this.getReferencesPatterns(componentName).length > 0 || this.getDeclarationPattern(componentName) != null;
    }

    public String[] getSupportedNamespaces() {
        return this.namespaces;
    }

    protected abstract void initializeDeclarations();

    protected abstract void initializeReferences();

    protected abstract void initializeSupportedNamespaces();
}

