/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.properties;

import java.util.Map;
import org.eclipse.ease.ui.scripts.Activator;
import org.eclipse.ease.ui.scripts.Messages;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AllKeywordsSection
extends AbstractPropertySection {
    private TableViewer fTableViewer;
    private boolean fContextMenuRegistered = false;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite mainComposite = this.getWidgetFactory().createComposite(parent, 0);
        FillLayout fl_mainComposite = new FillLayout(512);
        fl_mainComposite.marginWidth = 5;
        fl_mainComposite.marginHeight = 5;
        mainComposite.setLayout((Layout)fl_mainComposite);
        Composite tableComposite = this.getWidgetFactory().createComposite(mainComposite, 0);
        this.getWidgetFactory().paintBordersFor(tableComposite);
        TableColumnLayout tcl_composite = new TableColumnLayout();
        tableComposite.setLayout((Layout)tcl_composite);
        this.fTableViewer = new TableViewer(tableComposite, 67584);
        final Table table = this.fTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.getWidgetFactory().paintBordersFor((Composite)table);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.fTableViewer, 0);
        TableColumn tblclmnKeyword = tableViewerColumn.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnKeyword, (ColumnLayoutData)new ColumnWeightData(2, 20, true));
        tblclmnKeyword.setText(Messages.AllKeywordsSection_keyword);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)((Map.Entry)element).getKey();
            }

            public Image getImage(Object element) {
                String scriptValue = (String)AllKeywordsSection.this.getScript().getScriptKeywords().get(((Map.Entry)element).getKey());
                boolean isScriptKeyword = ((Map.Entry)element).getValue().equals(scriptValue);
                if (isScriptKeyword) {
                    return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ease.ui", (String)"/icons/eobj16/script.png").createImage();
                }
                return Activator.getImageDescriptor("/icons/eobj16/user.png").createImage();
            }
        });
        TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(this.fTableViewer, 0);
        TableColumn tblclmnValue = tableViewerColumn_1.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnValue, (ColumnLayoutData)new ColumnWeightData(5, 20, true));
        tblclmnValue.setText(Messages.AllKeywordsSection_value);
        this.fTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewerColumn_1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)((Map.Entry)element).getValue();
            }
        });
        tableViewerColumn_1.setEditingSupport(new EditingSupport((ColumnViewer)this.fTableViewer){

            protected void setValue(Object element, Object value) {
                String targetValue = value.toString().trim().isEmpty() ? null : value.toString().trim();
                AllKeywordsSection.this.getScript().setUserKeyword(((Map.Entry)element).getKey().toString(), targetValue);
                AllKeywordsSection.this.refresh();
            }

            protected Object getValue(Object element) {
                return ((Map.Entry)element).getValue().toString();
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)table);
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        this.fTableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((String)((Map.Entry)e1).getKey()).compareToIgnoreCase((String)((Map.Entry)e2).getKey());
            }
        });
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!this.fContextMenuRegistered) {
            MenuManager menuManager = new MenuManager();
            Menu contextMenu = menuManager.createContextMenu((Control)this.fTableViewer.getTable());
            this.fTableViewer.getTable().setMenu(contextMenu);
            this.getPart().getSite().registerContextMenu("org.eclipse.ease.scripts.properties.allKeywords", menuManager, (ISelectionProvider)this.fTableViewer);
            this.fContextMenuRegistered = true;
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void refresh() {
        this.fTableViewer.setInput(this.getScript().getKeywords().entrySet());
        this.fTableViewer.refresh();
    }

    public IScript getScript() {
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object candidate = ((IStructuredSelection)selection).getFirstElement();
            return (IScript)(candidate instanceof IScript ? candidate : null);
        }
        return null;
    }
}

