/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2MessagesUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowBuildInfo;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2PublicationMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2SubCallbackMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2MessageTransportInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2PubInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2SubCallbackInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2PublisherObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2SubscriptionObject;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

public class Ros2TransportMessageFlowSegment
extends Ros2MessageFlowSegment {
    private final @NonNull Ros2MessageTransportInstance fTransportInstance;
    private final @NonNull Ros2PublisherObject fPublisher;
    private final @NonNull Ros2SubscriptionObject fSubscription;

    public Ros2TransportMessageFlowSegment(long startTime, long endTime, @NonNull Ros2MessageTransportInstance transportInstance, @NonNull Ros2PublisherObject publisher, @NonNull Ros2SubscriptionObject subscription) {
        super(startTime, endTime, null);
        this.fTransportInstance = transportInstance;
        this.fPublisher = publisher;
        this.fSubscription = subscription;
    }

    public @NonNull Ros2MessageTransportInstance getTransportInstance() {
        return this.fTransportInstance;
    }

    public @NonNull Ros2PublisherObject getPublisher() {
        return this.fPublisher;
    }

    public @NonNull Ros2SubscriptionObject getSubscription() {
        return this.fSubscription;
    }

    @Override
    public @NonNull Collection<@NonNull Ros2MessageFlowSegment> getDirectSuccessors(@NonNull Ros2MessageFlowBuildInfo info) {
        ITmfStateInterval subCallbackInstanceInterval = Ros2MessagesUtil.getSubCallbackInstanceInterval(info.getMessagesSs(), info.getObjectsSs(), this.getTransportInstance().getDestinationTimestamp(), this.getTransportInstance().getSubscriptionHandle());
        if (subCallbackInstanceInterval == null) {
            return Collections.emptyList();
        }
        long startTime = subCallbackInstanceInterval.getStartTime();
        long endTime = subCallbackInstanceInterval.getEndTime();
        Ros2SubCallbackInstance subCallbackInstance = (Ros2SubCallbackInstance)((Object)subCallbackInstanceInterval.getValue());
        if (subCallbackInstance == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new Ros2SubCallbackMessageFlowSegment(startTime, endTime, subCallbackInstance, this.getSubscription()));
    }

    @Override
    public @NonNull Collection<@NonNull Ros2MessageFlowSegment> getDirectPredecessors(@NonNull Ros2MessageFlowBuildInfo info) {
        ITmfStateInterval pubInstanceInterval = Ros2MessagesUtil.getPubInstanceInterval(info.getMessagesSs(), info.getObjectsSs(), this.getTransportInstance().getSourceTimestamp() - 1L, this.getTransportInstance().getPublisherHandle());
        if (pubInstanceInterval == null) {
            return Collections.emptyList();
        }
        long startTime = pubInstanceInterval.getStartTime();
        long endTime = pubInstanceInterval.getEndTime();
        Ros2PubInstance pubInstance = (Ros2PubInstance)((Object)pubInstanceInterval.getValue());
        if (pubInstance == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new Ros2PublicationMessageFlowSegment(startTime, endTime, pubInstance, this.getPublisher()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.fTransportInstance, this.fPublisher, this.fSubscription, super.hashCode()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Ros2TransportMessageFlowSegment)) {
            return false;
        }
        Ros2TransportMessageFlowSegment o = (Ros2TransportMessageFlowSegment)obj;
        if (!this.fTransportInstance.equals((Object)o.fTransportInstance)) {
            return false;
        }
        if (!this.fPublisher.equals((Object)o.fPublisher)) {
            return false;
        }
        return this.fSubscription.equals((Object)o.fSubscription);
    }

    @Override
    public String toString() {
        return String.format("Ros2TransportMessageFlowSegment: %s, transportInstance=[%s], pub=[%s], sub=[%s]", super.toString(), this.fTransportInstance.toString(), this.fPublisher.toString(), this.fSubscription.toString());
    }
}

