/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.kernel.core.io;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class LinuxSocketFamily {
    private static final Map<Integer, String> SOCKET_FAMILY;

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)0, (Object)"AF_UNSPEC");
        builder.put((Object)1, (Object)"AF_UNIX");
        builder.put((Object)2, (Object)"AF_INET");
        builder.put((Object)3, (Object)"AF_AX25");
        builder.put((Object)4, (Object)"AF_IPX");
        builder.put((Object)5, (Object)"AF_APPLETALK");
        builder.put((Object)6, (Object)"AF_NETROM");
        builder.put((Object)7, (Object)"AF_BRIDGE");
        builder.put((Object)8, (Object)"AF_ATMPVC");
        builder.put((Object)9, (Object)"AF_X25");
        builder.put((Object)10, (Object)"AF_INET6");
        builder.put((Object)11, (Object)"AF_ROSE");
        builder.put((Object)12, (Object)"AF_DECnet");
        builder.put((Object)13, (Object)"AF_NETBEUI");
        builder.put((Object)14, (Object)"AF_SECURITY");
        builder.put((Object)15, (Object)"AF_KEY");
        builder.put((Object)16, (Object)"AF_NETLINK");
        builder.put((Object)17, (Object)"AF_PACKET");
        builder.put((Object)18, (Object)"AF_ASH");
        builder.put((Object)19, (Object)"AF_ECONET");
        builder.put((Object)20, (Object)"AF_ATMSVC");
        builder.put((Object)21, (Object)"AF_RDS");
        builder.put((Object)22, (Object)"AF_SNA");
        builder.put((Object)23, (Object)"AF_IRDA");
        builder.put((Object)24, (Object)"AF_PPPOX");
        builder.put((Object)25, (Object)"AF_WANPIPE");
        builder.put((Object)26, (Object)"AF_LLC");
        builder.put((Object)27, (Object)"AF_IB");
        builder.put((Object)28, (Object)"AF_MPLS");
        builder.put((Object)29, (Object)"AF_CAN");
        builder.put((Object)30, (Object)"AF_TIPC");
        builder.put((Object)31, (Object)"AF_BLUETOOTH");
        builder.put((Object)32, (Object)"AF_IUCV");
        builder.put((Object)33, (Object)"AF_RXRPC");
        builder.put((Object)34, (Object)"AF_ISDN");
        builder.put((Object)35, (Object)"AF_PHONET");
        builder.put((Object)36, (Object)"AF_IEEE802154");
        builder.put((Object)37, (Object)"AF_CAIF");
        builder.put((Object)38, (Object)"AF_ALG");
        builder.put((Object)39, (Object)"AF_NFC");
        builder.put((Object)40, (Object)"AF_VSOCK");
        builder.put((Object)41, (Object)"AF_KCM");
        builder.put((Object)42, (Object)"AF_QIPCRTR");
        builder.put((Object)43, (Object)"AF_SMC");
        builder.put((Object)44, (Object)"AF_XDP");
        SOCKET_FAMILY = builder.build();
    }

    public static String getSocketFamily(int family) {
        return SOCKET_FAMILY.getOrDefault(family, "UNKNOWN FAMILY " + family);
    }
}

