/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.resources;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.cdt.internal.core.resources.FileRelevance;
import org.eclipse.cdt.internal.core.resources.PathCanonicalizationStrategy;
import org.eclipse.cdt.internal.core.resources.ResourceLookupTree;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class ResourceLookup {
    private static ResourceLookupTree lookupTree = new ResourceLookupTree();

    public static void startup() {
        lookupTree.startup();
    }

    public static void shutdown() {
        lookupTree.shutdown();
    }

    public static IFile[] findFilesByName(IPath locationSuffix, IProject[] projects, boolean ignoreCase) {
        return lookupTree.findFilesByName(locationSuffix, projects, ignoreCase);
    }

    public static IFile[] findFilesForLocationURI(URI location) {
        return lookupTree.findFilesForLocationURI(location);
    }

    public static IFile[] findFilesForLocation(IPath location) {
        return lookupTree.findFilesForLocation(location);
    }

    public static IFile selectFileForLocationURI(URI location, IProject preferredProject) {
        return ResourceLookup.selectFile(ResourceLookup.findFilesForLocationURI(location), preferredProject, location);
    }

    public static IFile selectFileForLocation(IPath location, IProject preferredProject) {
        return ResourceLookup.selectFile(ResourceLookup.findFilesForLocation(location), preferredProject, location);
    }

    private static IFile selectFile(IFile[] files, IProject preferredProject, Object originalLocation) {
        int n;
        if (files.length == 0) {
            return null;
        }
        if (files.length == 1) {
            return files[0];
        }
        IFile best = null;
        int filesInPreferredProject = 0;
        if (preferredProject != null) {
            IFile[] iFileArray = files;
            n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (file.getProject().equals((Object)preferredProject) && file.isAccessible()) {
                    ++filesInPreferredProject;
                    best = file;
                }
                ++n2;
            }
        }
        if (filesInPreferredProject == 1) {
            return best;
        }
        int bestRelevance = -1;
        IFile[] iFileArray = files;
        int n3 = files.length;
        n = 0;
        while (n < n3) {
            IFile file = iFileArray[n];
            if (filesInPreferredProject == 0 || file.getProject().equals((Object)preferredProject)) {
                int relevance = FileRelevance.getRelevance(file, preferredProject, PathCanonicalizationStrategy.resolvesSymbolicLinks(), originalLocation);
                if (best == null || relevance > bestRelevance || relevance == bestRelevance && best.getFullPath().toString().compareTo(file.getFullPath().toString()) > 0) {
                    bestRelevance = relevance;
                    best = file;
                }
            }
            ++n;
        }
        return best;
    }

    public static void sortFilesByRelevance(IFile[] filesToSort, final IProject preferredProject) {
        Collections.sort(Arrays.asList(filesToSort), new Comparator<IFile>(){

            @Override
            public int compare(IFile f1, IFile f2) {
                int r2;
                int r1 = FileRelevance.getRelevance(f1, preferredProject);
                if (r1 > (r2 = FileRelevance.getRelevance(f2, preferredProject))) {
                    return -1;
                }
                if (r1 < r2) {
                    return 1;
                }
                return f1.getFullPath().toString().compareTo(f2.getFullPath().toString());
            }
        });
    }

    public static void dump() {
        lookupTree.dump();
    }

    public static void unrefNodeMap() {
        lookupTree.unrefNodeMap();
    }

    public static void simulateNodeMapCollection() {
        lookupTree.simulateNodeMapCollection();
    }
}

