/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.rocm.core.analysis;

public class RocmEventLayout {
    private static final String HIP_PREFIX = "hip";
    private static final String HIP_BEGIN_SUFFIX = "Begin";
    private static final String HIP_END_SUFFIX = "End";
    private static final String HSA_PREFIX = "hsa";
    private static final String HSA_BEGIN_SUFFIX = "_begin";
    private static final String HSA_END_SUFFIX = "_end";
    private static final String HIP_OPERATION_BEGIN = "hip_op_begin";
    private static final String HIP_OPERATION_END = "hip_op_end";
    private static final String HSA_OPERATION_BEGIN = "hsa_op_begin";
    private static final String HSA_OPERATION_END = "hsa_op_end";
    private static final String HIP_LAUNCH_PREFIX = "hipLaunch";
    private static final String HIP_EXT_LAUNCH_PREFIX = "hipExtLaunch";
    private static final String HIP_MEMCPY_PREFIX = "hipMemcpy";
    private static final String HIP_MEMCPY_BEGIN = "hipMemcpyBegin";
    private static final String HIP_MEMCPY_END = "hipMemcpyEnd";
    private static final String HIP_LAUNCH_KERNEL_BEGIN = "hipLaunchKernelBegin";
    private static final String HIP_LAUNCH_KERNEL_END = "hipLaunchKernelEnd";
    private static final String HIP_STREAM_SYNCHRONIZE_BEGIN = "hipStreamSynchronizeBegin";
    private static final String HIP_STREAM_SYNCHRONIZE_END = "hipStreamSynchronizeEnd";
    private static final String HSA_HANDLE_TYPE = "hsa_handle_type";
    private static final String THREAD_ID = "context._thread_id";
    private static final String QUEUE_ID = "context._queue_id";
    private static final String AGENT_ID = "context._agent_id";
    private static final String CORRELATION_ID = "context._correlation_id";
    private static final String KERNEL_NAME = "context._kernel_name";
    private static final String MEMCPY_KIND = "kind";
    private static final String OP_KERNEL_NAME = "kernel_name";

    public String hipMemcpyBegin() {
        return HIP_MEMCPY_BEGIN;
    }

    public String hipMemcpyEnd() {
        return HIP_MEMCPY_END;
    }

    public String hipLaunchKernelBegin() {
        return HIP_LAUNCH_KERNEL_BEGIN;
    }

    public String hipLaunchKernelEnd() {
        return HIP_LAUNCH_KERNEL_END;
    }

    public String hipStreamSynchronizeBegin() {
        return HIP_STREAM_SYNCHRONIZE_BEGIN;
    }

    public String hipStreamSynchronizeEnd() {
        return HIP_STREAM_SYNCHRONIZE_END;
    }

    public String getHipPrefix() {
        return HIP_PREFIX;
    }

    public String getHipBeginSuffix() {
        return HIP_BEGIN_SUFFIX;
    }

    public String getHipEndSuffix() {
        return HIP_END_SUFFIX;
    }

    public String getHsaPrefix() {
        return HSA_PREFIX;
    }

    public String getHsaBeginSuffix() {
        return HSA_BEGIN_SUFFIX;
    }

    public String getHsaEndSuffix() {
        return HSA_END_SUFFIX;
    }

    public String getHipOperationBegin() {
        return HIP_OPERATION_BEGIN;
    }

    public String getHipOperationEnd() {
        return HIP_OPERATION_END;
    }

    public String getHsaOperationBegin() {
        return HSA_OPERATION_BEGIN;
    }

    public String getHsaOperationEnd() {
        return HSA_OPERATION_END;
    }

    public String getHsaHandleType() {
        return HSA_HANDLE_TYPE;
    }

    public boolean isMemcpyBegin(String eventName) {
        return eventName.startsWith(HIP_MEMCPY_PREFIX) && eventName.endsWith(HIP_BEGIN_SUFFIX);
    }

    public boolean isLaunchBegin(String eventName) {
        return (eventName.startsWith(HIP_LAUNCH_PREFIX) || eventName.startsWith(HIP_EXT_LAUNCH_PREFIX)) && eventName.endsWith(HIP_BEGIN_SUFFIX);
    }

    public String fieldThreadId() {
        return THREAD_ID;
    }

    public String fieldQueueId() {
        return QUEUE_ID;
    }

    public String fieldAgentId() {
        return AGENT_ID;
    }

    public String fieldCorrelationId() {
        return CORRELATION_ID;
    }

    public String fieldKernelName() {
        return KERNEL_NAME;
    }

    public String fieldMemcpyKind() {
        return MEMCPY_KIND;
    }

    public String fieldOperationName() {
        return OP_KERNEL_NAME;
    }
}

