/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.event.aspect;

import java.util.ArrayList;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;

public class TmfEventFieldAspect
implements ITmfEventAspect<Object> {
    private static final char SLASH = '/';
    private static final char BACKSLASH = '\\';
    private final String fAspectName;
    private final IRootField fRootField;
    private final @Nullable String fFieldPath;
    private final String[] fFieldArray;

    public TmfEventFieldAspect(String aspectName, @Nullable String fieldPath, IRootField rootField) {
        this.fAspectName = aspectName;
        this.fFieldPath = fieldPath;
        this.fFieldArray = TmfEventFieldAspect.getFieldArray(fieldPath);
        this.fRootField = rootField;
    }

    public @Nullable String getFieldPath() {
        return this.fFieldPath;
    }

    public TmfEventFieldAspect forField(@Nullable String fieldPath) {
        return new TmfEventFieldAspect(this.fAspectName, fieldPath, this.fRootField);
    }

    @Override
    public String getName() {
        return this.fAspectName;
    }

    @Override
    public String getHelpText() {
        return "";
    }

    @Override
    public @Nullable Object resolve(ITmfEvent event) {
        ITmfEventField root = this.fRootField.getRootField(event);
        if (root == null) {
            return null;
        }
        if (this.fFieldArray.length == 0) {
            return root;
        }
        ITmfEventField field = root.getField(this.fFieldArray);
        if (field == null) {
            return null;
        }
        return field.getValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fAspectName.hashCode();
        String fieldPath = this.fFieldPath;
        result = 31 * result + (fieldPath == null ? 0 : fieldPath.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        TmfEventFieldAspect other = (TmfEventFieldAspect)obj;
        if (!this.fAspectName.equals(other.fAspectName)) {
            return false;
        }
        String fieldPath = this.fFieldPath;
        return !(fieldPath == null ? other.fFieldPath != null : !fieldPath.equals(other.fFieldPath));
    }

    private static String[] getFieldArray(@Nullable String field) {
        if (field == null) {
            return new String[0];
        }
        if (field.charAt(0) != '/') {
            return new String[]{field};
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        int i = 1;
        while (i < field.length()) {
            char charAt = field.charAt(i);
            if (charAt == '/') {
                list.add(sb.toString());
                sb = new StringBuilder();
            } else if (charAt == '\\' && i < field.length() - 1 && field.charAt(i + 1) == '/') {
                sb.append('/');
                ++i;
            } else {
                sb.append(charAt);
            }
            ++i;
        }
        list.add(sb.toString());
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public static interface IRootField {
        public @Nullable ITmfEventField getRootField(ITmfEvent var1);
    }
}

