/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.spin.analysis;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.Activator;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.spin.analysis.DpdkEthdevSpinAnalysisModule;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.spin.analysis.Messages;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.model.YModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.AbstractTreeCommonXDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class DpdkEthdevSpinDataProvider
extends AbstractTreeCommonXDataProvider<DpdkEthdevSpinAnalysisModule, TmfTreeDataModel>
implements IOutputStyleProvider {
    public static final String ID = "org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.spin.dataprovider";
    private static final String PROVIDER_TITLE = Objects.requireNonNull("DPDK Threads Effective CPU Usage");
    private static final String BASE_STYLE = "base";
    private static final String THREADS_LABEL = Objects.requireNonNull(Messages.DpdkEthdevSpin_DataProvider_Threads);
    private static final Map<String, OutputElementStyle> STATE_MAP;

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)BASE_STYLE, (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"series-type", (Object)"scatter", (Object)"width", (Object)Float.valueOf(1.0f))));
        STATE_MAP = builder.build();
    }

    public static @Nullable DpdkEthdevSpinDataProvider create(ITmfTrace trace) {
        DpdkEthdevSpinAnalysisModule module = (DpdkEthdevSpinAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, DpdkEthdevSpinAnalysisModule.class, (String)"org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.spin.analysis");
        if (module != null) {
            module.schedule();
            return new DpdkEthdevSpinDataProvider(trace, module);
        }
        return null;
    }

    private DpdkEthdevSpinDataProvider(ITmfTrace trace, DpdkEthdevSpinAnalysisModule module) {
        super(trace, (TmfStateSystemAnalysisModule)module);
    }

    public String getId() {
        return ID;
    }

    protected TmfTreeModel<TmfTreeDataModel> getTree(ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) {
        ArrayList<TmfTreeDataModel> nodes = new ArrayList<TmfTreeDataModel>();
        long rootId = this.getId(-1);
        nodes.add(new TmfTreeDataModel(rootId, -1L, Collections.singletonList(Objects.requireNonNull(this.getTrace().getName())), false, null));
        try {
            int threadsQuark = ss.getQuarkAbsolute(new String[]{"Threads"});
            long threadsId = this.getId(threadsQuark);
            nodes.add(new TmfTreeDataModel(threadsId, rootId, Collections.singletonList(THREADS_LABEL), false, null));
            for (Integer threadQuark : ss.getQuarks(new String[]{"Threads", "*"})) {
                String threadName = ss.getAttributeName(threadQuark.intValue());
                long threadId = this.getId(threadQuark);
                nodes.add(new TmfTreeDataModel(threadId, threadsId, Collections.singletonList(threadName), false, null));
            }
        }
        catch (AttributeNotFoundException e) {
            Activator.getInstance().logError("Error getting the root attribute of Threads");
        }
        return new TmfTreeModel(Collections.emptyList(), nodes);
    }

    private static long getInitialPrevTime(SelectionTimeQueryFilter filter) {
        long startTime = filter.getStart();
        long[] lArray = filter.getTimesRequested();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long time = lArray[n2];
            if (time > startTime) {
                return startTime - (time - startTime);
            }
            ++n2;
        }
        return startTime;
    }

    protected @Nullable Collection<IYModel> getYSeriesModels(ITmfStateSystem ss, Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(fetchParameters);
        if (filter == null || this.getSelectedEntries(filter).isEmpty()) {
            return null;
        }
        HashSet<Integer> threadQuarks = new HashSet<Integer>();
        HashMap<String, IYModel> threadYModels = new HashMap<String, IYModel>();
        for (Map.Entry entry : this.getSelectedEntries(filter).entrySet()) {
            int quark = Objects.requireNonNull((Integer)entry.getValue());
            if (quark == -1 || ss.getParentAttributeQuark(quark) == -1) continue;
            threadQuarks.add(quark);
            String name = ss.getAttributeName(quark);
            threadYModels.put(name, (IYModel)new YModel(((Long)entry.getKey()).longValue(), this.getTrace().getName() + "/" + name, new double[filter.getTimesRequested().length]));
        }
        this.calculateThreadStatePercentages(ss, filter, monitor, threadQuarks, threadYModels);
        return ImmutableList.copyOf(threadYModels.values());
    }

    private void calculateThreadStatePercentages(ITmfStateSystem ss, SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor, Set<Integer> threadQuarks, Map<String, IYModel> threadYModels) {
        long[] xValues = filter.getTimesRequested();
        long prevTime = Math.max(DpdkEthdevSpinDataProvider.getInitialPrevTime(filter), ss.getStartTime());
        long currentEnd = ss.getCurrentEndTime();
        int i = 0;
        while (i < xValues.length) {
            long currentTime = xValues[i];
            if (currentTime < ss.getStartTime() || currentTime > currentEnd) {
                prevTime = currentTime;
            } else {
                if (prevTime < currentTime) {
                    Map<String, Pair<Long, Long>> threadUsageMap = ((DpdkEthdevSpinAnalysisModule)this.getAnalysisModule()).calculateThreadStateDurations(threadQuarks, prevTime, currentTime);
                    int index = i;
                    threadUsageMap.forEach((key, durations) -> {
                        IYModel values = (IYModel)threadYModels.get(key);
                        if (values != null) {
                            values.getData()[n] = DpdkEthdevSpinDataProvider.getPercentageValue((Long)durations.getFirst(), (Long)durations.getSecond());
                        }
                    });
                } else if (i > 0) {
                    for (IYModel values : threadYModels.values()) {
                        values.getData()[i] = values.getData()[i - 1];
                    }
                }
                prevTime = currentTime;
                if (monitor != null && monitor.isCanceled()) {
                    return;
                }
            }
            ++i;
        }
    }

    private static double getPercentageValue(long countActive, long countSpin) {
        return countActive + countSpin == 0L ? 0.0 : (double)countActive * 100.0 / (double)(countActive + countSpin);
    }

    protected boolean isCacheable() {
        return true;
    }

    protected String getTitle() {
        return PROVIDER_TITLE;
    }

    public TmfModelResponse<OutputStyleModel> fetchStyle(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse((Object)new OutputStyleModel(STATE_MAP), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }
}

