/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.parser;

import java.io.IOException;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceDataType;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.parser.BinaryFTraceFileMapping;

public class BinaryFTraceByteBuffer {
    private BinaryFTraceFileMapping fMappedBuffer;
    private long fCurrentOffset = 0L;

    public BinaryFTraceByteBuffer(String filePath) throws IOException {
        this(new BinaryFTraceFileMapping(filePath));
    }

    public BinaryFTraceByteBuffer(BinaryFTraceFileMapping mappedBuffer) {
        this.fMappedBuffer = mappedBuffer;
    }

    public void movePointerToOffset(long offset) {
        this.fCurrentOffset = offset;
    }

    public byte[] getNextBytes(int byteCount) {
        byte[] bytesArray = new byte[byteCount];
        this.fMappedBuffer.get(this.fCurrentOffset, bytesArray);
        this.fCurrentOffset += (long)byteCount;
        return bytesArray;
    }

    public String getNextString() {
        long pos = this.fCurrentOffset;
        StringBuilder strBuilder = new StringBuilder();
        byte value = this.fMappedBuffer.getByte(pos++);
        while (value > 0) {
            strBuilder.append((char)value);
            value = this.fMappedBuffer.getByte(pos++);
        }
        String returnString = strBuilder.toString();
        this.fCurrentOffset += (long)(returnString.length() + 1);
        return returnString;
    }

    public String getNextBytesAsString(long byteCount) {
        if (byteCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("FTrace Binary buffer: byteCount too large: " + byteCount);
        }
        return new String(this.getNextBytes((int)byteCount));
    }

    public int getNextInt() {
        int value = this.fMappedBuffer.getInt(this.fCurrentOffset);
        this.fCurrentOffset += (long)BinaryFTraceDataType.INT.getSize();
        return value;
    }

    public double getNextDouble() {
        double value = this.fMappedBuffer.getDouble(this.fCurrentOffset);
        this.fCurrentOffset += 8L;
        return value;
    }

    public long getNextLong() {
        long value = this.fMappedBuffer.getLong(this.fCurrentOffset);
        this.fCurrentOffset += 8L;
        return value;
    }

    public short getNextShort() {
        short value = this.fMappedBuffer.getShort(this.fCurrentOffset);
        this.fCurrentOffset += 2L;
        return value;
    }

    public long getCurrentOffset() {
        return this.fCurrentOffset;
    }

    public long getFileSize() {
        return this.fMappedBuffer.length();
    }
}

