/*******************************************************************************
 * Copyright (c) 2024 École Polytechnique de Montréal
 *
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License 2.0 which
 * accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *******************************************************************************/
package org.eclipse.tracecompass.incubator.rocm.core.exatracer.trace;

import org.eclipse.tracecompass.incubator.gpu.core.trace.IGpuTraceEventLayout.IApiEventLayout;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

/**
 * Event layout for API events in traces generated by exatracer
 *
 * @author Arnaud Fiorini
 */
public abstract class RocmApiEventLayout implements IApiEventLayout {

    @Override
    public boolean isBeginEvent(ITmfEvent event) {
        return event.getName().endsWith(RocmExatracerTraceEventLayout.BEGIN_SUFFIX);
    }

    @Override
    public String getEventName(ITmfEvent event) {
        if (isBeginEvent(event)) {
            return event.getName().substring(4, event.getName().length() - 6);
        }
        return event.getName().substring(4, event.getName().length() - 5);
    }
}
