/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.scripting;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryManager;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.scripting.CreateRefactoringScriptWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.scripting.ScriptingMessages;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;

public final class CreateRefactoringScriptWizard
extends Wizard {
    private static String DIALOG_SETTINGS_KEY = "CreateRefactoringScriptWizard";
    private boolean fNewSettings;
    private RefactoringDescriptorProxy[] fRefactoringDescriptors = new RefactoringDescriptorProxy[0];
    private RefactoringHistory fRefactoringHistory;
    private URI fScriptLocation = null;
    private boolean fUseClipboard = false;
    private final CreateRefactoringScriptWizardPage fWizardPage;

    public CreateRefactoringScriptWizard() {
        this.setNeedsProgressMonitor(false);
        this.setWindowTitle(ScriptingMessages.CreateRefactoringScriptWizard_caption);
        this.setDefaultPageImageDescriptor(RefactoringPluginImages.DESC_WIZBAN_CREATE_SCRIPT);
        IDialogSettings settings = RefactoringUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            this.fNewSettings = true;
        } else {
            this.fNewSettings = false;
            this.setDialogSettings(section);
        }
        this.fWizardPage = new CreateRefactoringScriptWizardPage(this);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.fWizardPage);
    }

    public boolean canFinish() {
        return (this.fUseClipboard || this.fScriptLocation != null) && this.fRefactoringDescriptors.length > 0;
    }

    public RefactoringHistory getRefactoringHistory() {
        return this.fRefactoringHistory;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean performExport() {
        RefactoringDescriptorProxy[] writable = this.fRefactoringDescriptors;
        if (this.fScriptLocation != null) {
            File file = new File(this.fScriptLocation);
            if (file.exists()) {
                MessageDialog message = new MessageDialog(this.getShell(), this.getShell().getText(), null, Messages.format(ScriptingMessages.CreateRefactoringScriptWizard_overwrite_query, new String[]{ScriptingMessages.CreateRefactoringScriptWizard_merge_button, ScriptingMessages.CreateRefactoringScriptWizard_overwrite_button}), 3, new String[]{ScriptingMessages.CreateRefactoringScriptWizard_merge_button, ScriptingMessages.CreateRefactoringScriptWizard_overwrite_button, IDialogConstants.CANCEL_LABEL}, 0);
                int result = message.open();
                if (result == 0) {
                    try {
                        Throwable throwable = null;
                        Object var6_22 = null;
                        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
                            RefactoringDescriptorProxy[] existing = RefactoringCore.getHistoryService().readRefactoringHistory((InputStream)stream, 0).getDescriptors();
                            HashSet<RefactoringDescriptorProxy> set = new HashSet<RefactoringDescriptorProxy>(Arrays.asList(existing));
                            set.addAll(Arrays.asList(this.fRefactoringDescriptors));
                            writable = new RefactoringDescriptorProxy[set.size()];
                            set.toArray(writable);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (FileNotFoundException exception) {
                        MessageDialog.openError((Shell)this.getShell(), (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)exception.getLocalizedMessage());
                        return false;
                    }
                    catch (CoreException exception23332) {
                        this.handleCoreException(exception23332);
                        return false;
                    }
                    catch (IOException exception23332) {}
                } else if (result == 2) {
                    return false;
                }
            }
            try {
                File parentFile = file.getParentFile();
                if (parentFile != null) {
                    parentFile.mkdirs();
                }
                Throwable result = null;
                Object exception23332 = null;
                try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
                    this.writeRefactoringDescriptorProxies(writable, stream);
                }
                catch (Throwable exception23332) {
                    if (result == null) {
                        result = exception23332;
                    } else if (result != exception23332) {
                        result.addSuppressed(exception23332);
                    }
                    throw result;
                }
                return true;
            }
            catch (CoreException exception) {
                this.handleCoreException(exception);
                return false;
            }
            catch (FileNotFoundException exception) {
                MessageDialog.openError((Shell)this.getShell(), (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)exception.getLocalizedMessage());
                return false;
            }
            catch (IOException exception) {}
        } else if (this.fUseClipboard) {
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream(2048);
                this.writeRefactoringDescriptorProxies(writable, stream);
                try {
                    String string = stream.toString("utf-8");
                    Clipboard clipboard = null;
                    try {
                        clipboard = new Clipboard(this.getShell().getDisplay());
                        try {
                            clipboard.setContents(new Object[]{string}, new Transfer[]{TextTransfer.getInstance()});
                            return true;
                        }
                        catch (SWTError error) {
                            block46: {
                                MessageDialog.openError((Shell)this.getShell(), (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)error.getLocalizedMessage());
                                if (clipboard == null) break block46;
                                clipboard.dispose();
                            }
                            return false;
                        }
                    }
                    finally {
                        if (clipboard != null) {
                            clipboard.dispose();
                        }
                    }
                }
                catch (UnsupportedEncodingException exception) {
                    return false;
                }
            }
            catch (CoreException exception) {
                this.handleCoreException(exception);
                return false;
            }
        }
        return false;
    }

    private void handleCoreException(CoreException exception) {
        IStatus status = exception.getStatus();
        Throwable throwable = status.getException();
        if (throwable instanceof IOException) {
            MessageDialog.openError((Shell)this.getShell(), (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)throwable.getLocalizedMessage());
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)status.getMessage());
            RefactoringUIPlugin.log(exception);
        }
    }

    public boolean performFinish() {
        if (this.fNewSettings) {
            IDialogSettings settings = RefactoringUIPlugin.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection(DIALOG_SETTINGS_KEY);
            section = settings.addNewSection(DIALOG_SETTINGS_KEY);
            this.setDialogSettings(section);
        }
        this.fWizardPage.performFinish();
        return this.performExport();
    }

    public void setRefactoringDescriptors(RefactoringDescriptorProxy[] proxies) {
        Assert.isNotNull((Object)proxies);
        this.fRefactoringDescriptors = proxies;
        IWizardContainer wizard = this.getContainer();
        if (wizard.getCurrentPage() != null) {
            wizard.updateButtons();
        }
    }

    public void setRefactoringHistory(RefactoringHistory history) {
        Assert.isNotNull((Object)history);
        this.fRefactoringHistory = history;
    }

    public void setRefactoringScript(URI location) {
        this.fScriptLocation = location;
        IWizardContainer wizard = this.getContainer();
        if (wizard.getCurrentPage() != null) {
            wizard.updateButtons();
        }
    }

    public void setUseClipboard(boolean clipboard) {
        this.fUseClipboard = clipboard;
        IWizardContainer wizard = this.getContainer();
        if (wizard.getCurrentPage() != null) {
            wizard.updateButtons();
        }
    }

    private void writeRefactoringDescriptorProxies(RefactoringDescriptorProxy[] writable, OutputStream stream) throws CoreException {
        RefactoringHistoryManager.sortRefactoringDescriptorsAscending((RefactoringDescriptorProxy[])writable);
        try {
            this.getContainer().run(false, false, monitor -> {
                try {
                    RefactoringCore.getHistoryService().writeRefactoringDescriptors(writable, stream, 0, false, monitor);
                }
                catch (CoreException exception) {
                    throw new InvocationTargetException(exception);
                }
            });
        }
        catch (InvocationTargetException exception) {
            Throwable throwable = exception.getTargetException();
            if (throwable instanceof CoreException) {
                CoreException extended = (CoreException)throwable;
                throw extended;
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ltk.core.refactoring", ScriptingMessages.CreateRefactoringScriptWizard_unexpected_exception, throwable));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

