/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow;

import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowBuildInfo;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowSegment;

public class Ros2MessageFlowBuilder {
    private final @NonNull Ros2MessageFlowBuildInfo fBuildInfo;
    protected final @NonNull HashMap<@NonNull Ros2MessageFlowSegment, @NonNull Ros2MessageFlowSegment> fSegments;

    public Ros2MessageFlowBuilder(@NonNull Ros2MessageFlowBuildInfo buildInfo, @NonNull HashMap<@NonNull Ros2MessageFlowSegment, @NonNull Ros2MessageFlowSegment> segments) {
        this.fBuildInfo = buildInfo;
        this.fSegments = segments;
    }

    public @NonNull Ros2MessageFlowBuildInfo getBuildInfo() {
        return this.fBuildInfo;
    }

    public void getNextSegments(@NonNull Ros2MessageFlowSegment segment) {
        this.getNextSegments(segment, true);
    }

    public void getPreviousSegments(@NonNull Ros2MessageFlowSegment segment) {
        this.getNextSegments(segment, false);
    }

    private void getNextSegments(@NonNull Ros2MessageFlowSegment segment, boolean forward) {
        Collection<@NonNull Ros2MessageFlowSegment> nextSegments = forward ? segment.getDirectSuccessors(this.getBuildInfo()) : segment.getDirectPredecessors(this.getBuildInfo());
        for (Ros2MessageFlowSegment nextSegment : nextSegments) {
            boolean nextExistsAlready = this.fSegments.containsKey(nextSegment);
            if (nextExistsAlready) {
                nextSegment = Objects.requireNonNull(this.fSegments.get(nextSegment));
            } else {
                this.fSegments.put(nextSegment, nextSegment);
            }
            nextSegment.addPrevious(segment);
            segment.addNext(nextSegment);
            if (nextExistsAlready) continue;
            this.getNextSegments(nextSegment, forward);
        }
    }
}

