/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.NamedMember;
import org.eclipse.wst.jsdt.internal.core.ResolvedSourceField;
import org.eclipse.wst.jsdt.internal.core.SourceFieldElementInfo;

public class SourceField
extends NamedMember
implements IField {
    protected SourceField(JavaElement parent, String name) {
        super(parent, name);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SourceField)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public ASTNode findNode(JavaScriptUnit ast) {
        ASTNode node = super.findNode(ast);
        if (node == null) {
            return null;
        }
        return node.getParent();
    }

    public Object getConstant() throws JavaScriptModelException {
        String constant = null;
        SourceFieldElementInfo info = (SourceFieldElementInfo)this.getElementInfo();
        char[] constantSourceChars = info.initializationSource;
        if (constantSourceChars == null) {
            return null;
        }
        String constantSource = new String(constantSourceChars);
        String signature = info.getTypeSignature();
        try {
            if (signature.equals("QString;")) {
                constant = constantSource;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return constant;
    }

    @Override
    public int getElementType() {
        return 8;
    }

    @Override
    public String getKey() {
        try {
            return this.getKey(this, false);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return null;
        }
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '^';
    }

    @Override
    public IJavaScriptElement getPrimaryElement(boolean checkOwner) {
        CompilationUnit cu;
        if (checkOwner && (cu = (CompilationUnit)this.getAncestor(5)).isPrimary()) {
            return this;
        }
        IJavaScriptElement primaryParent = this.parent.getPrimaryElement(false);
        if (primaryParent instanceof IType) {
            return ((IType)primaryParent).getField(this.name);
        }
        return ((IJavaScriptUnit)primaryParent).getField(this.name);
    }

    @Override
    public String getTypeSignature() throws JavaScriptModelException {
        SourceFieldElementInfo info = (SourceFieldElementInfo)this.getElementInfo();
        return info.getTypeSignature();
    }

    @Override
    public boolean isResolved() {
        return false;
    }

    @Override
    public JavaElement resolved(Binding binding) {
        ResolvedSourceField resolvedHandle = new ResolvedSourceField(this.parent, this.name, new String(binding.computeUniqueKey()));
        resolvedHandle.occurrenceCount = this.occurrenceCount;
        return resolvedHandle;
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == NO_INFO) {
            this.toStringName(buffer);
        } else {
            buffer.append("var ");
            this.toStringName(buffer);
        }
    }
}

