/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.traceevent.core.event;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;

@NonNullByDefault
public class TraceEventField {
    public static final String UNKNOWN_EXIT_EVENT = "exit unknown";
    public static final String UNKNOWN_DURATION_EXIT_EVENT = "duration exit";
    private static final double MICRO_TO_NANO = 1000.0;
    private final long fTs;
    private final char fPhase;
    private final String fName;
    private ITmfEventField fContent;
    private final @Nullable Map<String, Object> fArgs;
    private final @Nullable Object fTid;
    private final @Nullable String fCategory;
    private final @Nullable String fId;
    private final @Nullable Long fDuration;
    private final @Nullable Object fPid;
    private static final Gson G_SON = new Gson();

    public static @Nullable TraceEventField parseJson(String fieldsString) {
        JsonPrimitive primitive;
        String phase;
        HashMap<@NonNull String, @NonNull Object> argsMap = new HashMap<String, Object>();
        JsonObject root = (JsonObject)G_SON.fromJson(fieldsString, JsonObject.class);
        long ts = 0L;
        if (root.size() == 0) {
            return null;
        }
        JsonElement timestamp = root.get("ts");
        if (timestamp == null) {
            return null;
        }
        Double tso = timestamp.getAsDouble();
        if (Double.isFinite(tso)) {
            ts = (long)(tso * 1000.0);
        }
        if ((phase = TraceEventField.optString(root, "ph", "I")) == null) {
            phase = "I";
        }
        String name = String.valueOf(TraceEventField.optString(root, "name", "E".equals(phase) ? UNKNOWN_DURATION_EXIT_EVENT : UNKNOWN_EXIT_EVENT));
        String tid = TraceEventField.optString(root, "tid", null);
        JsonElement jsonElement = root.get("pid");
        JsonPrimitive jsonPrimitive = jsonElement == null ? null : (primitive = jsonElement.isJsonPrimitive() ? jsonElement.getAsJsonPrimitive() : null);
        Number pid = primitive == null ? null : (primitive.isNumber() ? primitive.getAsNumber() : (primitive.isString() ? primitive.getAsString() : null));
        Double duration = TraceEventField.optDouble(root, "dur");
        if (Double.isFinite(duration)) {
            duration = duration * 1000.0;
        }
        String category = TraceEventField.optString(root, "cat");
        String id = TraceEventField.optString(root, "id");
        String scope = TraceEventField.optString(root, "scope");
        JsonObject args = TraceEventField.optJSONObject(root, "args");
        if (args != null) {
            for (Map.Entry entry : args.entrySet()) {
                String key = Objects.requireNonNull((String)entry.getKey());
                JsonElement element = Objects.requireNonNull((JsonElement)entry.getValue());
                String value = String.valueOf(element.isJsonPrimitive() ? element.getAsJsonPrimitive().getAsString() : element.toString());
                argsMap.put("args/" + key, value);
            }
        }
        argsMap.put("ts", timestamp.getAsString());
        argsMap.put("ph", phase);
        argsMap.put("name", name);
        if (tid != null) {
            argsMap.put("tid", tid);
        }
        if (pid != null) {
            argsMap.put("pid", pid);
        }
        if (Double.isFinite(duration)) {
            argsMap.put("dur", duration);
        }
        if (category != null) {
            argsMap.put("cat", category);
        }
        if (id != null) {
            argsMap.put("id", id);
        }
        if (scope != null) {
            argsMap.put("scope", scope);
        }
        return new TraceEventField(name, ts, phase, pid, tid, category, id, duration, argsMap);
    }

    private static double optDouble(JsonObject root, String key) {
        JsonElement jsonElement = root.get(key);
        return jsonElement != null ? jsonElement.getAsDouble() : Double.NaN;
    }

    private static @Nullable JsonObject optJSONObject(JsonObject root, String key) {
        JsonElement jsonElement = root.get(key);
        return jsonElement != null ? jsonElement.getAsJsonObject() : null;
    }

    private static @Nullable String optString(JsonObject root, String key, @Nullable String defaultValue) {
        JsonElement jsonElement = root.get(key);
        return jsonElement != null ? jsonElement.getAsString() : defaultValue;
    }

    private static @Nullable String optString(JsonObject root, String key) {
        return TraceEventField.optString(root, key, null);
    }

    protected TraceEventField(String name, long ts, String phase, @Nullable Object pid, @Nullable Object tid, @Nullable String category, @Nullable String id, @Nullable Double duration, Map<String, Object> fields) {
        this.fName = name;
        this.fPid = pid;
        this.fTid = tid;
        this.fCategory = category;
        this.fId = id;
        ITmfEventField[] array = (ITmfEventField[])fields.entrySet().stream().map(entry -> new TmfEventField((String)entry.getKey(), entry.getValue(), null)).toArray(ITmfEventField[]::new);
        this.fContent = new TmfEventField(":root:", fields, array);
        fields.put("ts", (double)ts / 1000.0);
        this.fTs = ts;
        this.fDuration = duration == null ? null : (Double.isFinite(duration) ? Long.valueOf(duration.longValue()) : null);
        this.fPhase = phase.charAt(0);
        Map<@NonNull String, @NonNull Object> args = fields.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("args/")).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(5), Map.Entry::getValue));
        this.fArgs = args.isEmpty() ? null : args;
    }

    public @Nullable String getCategory() {
        return this.fCategory;
    }

    public ITmfEventField getContent() {
        return this.fContent;
    }

    public @Nullable String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public char getPhase() {
        return this.fPhase;
    }

    public @Nullable Object getTid() {
        return this.fTid;
    }

    public long getTs() {
        return this.fTs;
    }

    public @Nullable Long getDuration() {
        return this.fDuration;
    }

    public @Nullable Object getPid() {
        return this.fPid;
    }

    public @Nullable Map<String, Object> getArgs() {
        return this.fArgs;
    }
}

