/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.ISemanticProblem;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.DependentValue;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.SizeofCalculator;
import org.eclipse.cdt.internal.core.dom.parser.ValueFactory;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPArithmeticConversion;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClosureType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalCompositeAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFunctionCall;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalMemberAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalPointer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.core.runtime.CoreException;

public class EvalUnary
extends CPPDependentEvaluation {
    private static final ICPPEvaluation ZERO_EVAL = new EvalFixed(CPPSemantics.INT_TYPE, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(0L));
    private final int fOperator;
    private final ICPPEvaluation fArgument;
    private final IBinding fAddressOfQualifiedNameBinding;
    private ICPPFunction fOverload = CPPFunction.UNINITIALIZED_FUNCTION;
    private IType fType;
    private boolean fCheckedIsConstantExpression;
    private boolean fIsConstantExpression;

    public EvalUnary(int operator, ICPPEvaluation operand, IBinding addressOfQualifiedNameBinding, IASTNode pointOfDefinition) {
        this(operator, operand, addressOfQualifiedNameBinding, EvalUnary.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalUnary(int operator, ICPPEvaluation operand, IBinding addressOfQualifiedNameBinding, IBinding templateDefinition) {
        super(templateDefinition);
        this.fOperator = operator;
        this.fArgument = operand;
        this.fAddressOfQualifiedNameBinding = addressOfQualifiedNameBinding;
    }

    public int getOperator() {
        return this.fOperator;
    }

    public ICPPEvaluation getArgument() {
        return this.fArgument;
    }

    public IBinding getAddressOfQualifiedNameBinding() {
        return this.fAddressOfQualifiedNameBinding;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        if (this.fType != null) {
            return this.fType instanceof TypeOfDependentExpression;
        }
        switch (this.fOperator) {
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                return false;
            }
        }
        return this.fArgument.isTypeDependent();
    }

    @Override
    public boolean isValueDependent() {
        switch (this.fOperator) {
            case 8: 
            case 13: 
            case 15: 
            case 16: {
                return this.fArgument.isTypeDependent();
            }
            case 17: {
                return this.fArgument.referencesTemplateParameter();
            }
            case 12: {
                return false;
            }
            case 19: {
                return true;
            }
        }
        return this.fArgument.isValueDependent();
    }

    @Override
    public boolean isConstantExpression() {
        if (!this.fCheckedIsConstantExpression) {
            this.fCheckedIsConstantExpression = true;
            this.fIsConstantExpression = this.computeIsConstantExpression();
        }
        return this.fIsConstantExpression;
    }

    private boolean computeIsConstantExpression() {
        return this.fArgument.isConstantExpression() && EvalUnary.isNullOrConstexprFunc(this.getOverload());
    }

    @Override
    public boolean isEquivalentTo(ICPPEvaluation other) {
        if (!(other instanceof EvalUnary)) {
            return false;
        }
        EvalUnary o = (EvalUnary)other;
        return this.fOperator == o.fOperator && this.fArgument.isEquivalentTo(o.fArgument);
    }

    public ICPPFunction getOverload() {
        if (this.fOverload == CPPFunction.UNINITIALIZED_FUNCTION) {
            this.fOverload = this.computeOverload();
        }
        return this.fOverload;
    }

    private ICPPFunction computeOverload() {
        ICPPMember member;
        OverloadableOperator op = OverloadableOperator.fromUnaryExpression(this.fOperator);
        if (op == null) {
            return null;
        }
        if (this.fArgument.isTypeDependent()) {
            return null;
        }
        if (this.fAddressOfQualifiedNameBinding instanceof ICPPMember && !(member = (ICPPMember)this.fAddressOfQualifiedNameBinding).isStatic()) {
            return null;
        }
        IType type = this.fArgument.getType();
        if (!CPPSemantics.isUserDefined(type = SemanticUtil.getNestedType(type, 13))) {
            return null;
        }
        ICPPEvaluation[] args = this.fOperator == 10 || this.fOperator == 9 ? new ICPPEvaluation[]{this.fArgument, ZERO_EVAL} : new ICPPEvaluation[]{this.fArgument};
        return CPPSemantics.findOverloadedOperator(this.getTemplateDefinitionScope(), args, type, op, CPPSemantics.LookupMode.LIMITED_GLOBALS);
    }

    @Override
    public IType getType() {
        if (this.fType == null) {
            this.fType = this.computeType();
        }
        return this.fType;
    }

    private IType computeType() {
        if (this.isTypeDependent()) {
            return new TypeOfDependentExpression(this);
        }
        ICPPFunction overload = this.getOverload();
        if (overload != null) {
            return ExpressionTypes.typeFromFunctionCall(overload);
        }
        switch (this.fOperator) {
            case 8: 
            case 16: {
                return CPPVisitor.get_SIZE_T();
            }
            case 13: {
                return CPPVisitor.get_type_info();
            }
            case 12: {
                return CPPSemantics.VOID_TYPE;
            }
            case 19: {
                return this.fArgument.getType();
            }
            case 5: {
                ICPPMember member;
                if (this.fAddressOfQualifiedNameBinding instanceof ICPPMember && !(member = (ICPPMember)this.fAddressOfQualifiedNameBinding).isStatic()) {
                    try {
                        return new CPPPointerToMemberType(member.getType(), member.getClassOwner(), false, false, false);
                    }
                    catch (DOMException e) {
                        return e.getProblem();
                    }
                }
                return new CPPPointerType(this.fArgument.getType());
            }
            case 4: {
                IType type = this.fArgument.getType();
                type = ExpressionTypes.prvalueTypeWithResolvedTypedefs(type);
                if (type instanceof IPointerType) {
                    return ExpressionTypes.glvalueType(((IPointerType)type).getType());
                }
                if (type instanceof ISemanticProblem) {
                    return type;
                }
                return ProblemType.UNKNOWN_FOR_EXPRESSION;
            }
            case 7: 
            case 17: {
                return CPPBasicType.BOOLEAN;
            }
            case 9: 
            case 10: {
                return ExpressionTypes.prvalueType(this.fArgument.getType());
            }
            case 2: {
                return this.promoteType(this.fArgument.getType(), true);
            }
            case 3: 
            case 6: {
                return this.promoteType(this.fArgument.getType(), false);
            }
        }
        return this.fArgument.getType();
    }

    private IType promoteType(IType type, boolean allowPointer) {
        IType t3;
        IType t1 = ExpressionTypes.prvalueType(type);
        IType t2 = SemanticUtil.getNestedType(t1, 1);
        if (allowPointer) {
            if (t2 instanceof CPPClosureType) {
                ICPPMethod conversionOperator = ((CPPClosureType)t2).getConversionOperator();
                if (conversionOperator == null) {
                    return ProblemType.UNKNOWN_FOR_EXPRESSION;
                }
                return new CPPPointerType(conversionOperator.getType().getReturnType());
            }
            if (t2 instanceof IPointerType) {
                return t1;
            }
        }
        if ((t3 = CPPArithmeticConversion.promoteCppType(t2)) == null && !(t2 instanceof IBasicType)) {
            return ProblemType.UNKNOWN_FOR_EXPRESSION;
        }
        return t3 == null || t3 == t2 ? t1 : t3;
    }

    @Override
    public IValue getValue() {
        if (this.isValueDependent()) {
            return DependentValue.create(this);
        }
        ICPPEvaluation arg = this.fArgument;
        ICPPFunction overload = this.getOverload();
        if (overload != null) {
            ICPPFunctionType functionType = overload.getType();
            IType[] parameterTypes = functionType.getParameterTypes();
            if (parameterTypes.length == 0) {
                return IntegralValue.ERROR;
            }
            IType targetType = parameterTypes[0];
            arg = EvalUnary.maybeApplyConversion(arg, targetType, this.fOperator == 7, false);
            if (!(overload instanceof CPPImplicitFunction)) {
                if (!overload.isConstexpr()) {
                    return IntegralValue.ERROR;
                }
                EvalBinding eval = new EvalBinding((IBinding)overload, null, null);
                arg = new EvalFunctionCall(new ICPPEvaluation[]{eval, arg}, null, null);
                return arg.getValue();
            }
        }
        switch (this.fOperator) {
            case 8: {
                SizeofCalculator.SizeAndAlignment info = SizeofCalculator.getSizeAndAlignment(this.fArgument.getType());
                return info == null ? IntegralValue.UNKNOWN : IntegralValue.create(info.size);
            }
            case 15: {
                SizeofCalculator.SizeAndAlignment info = SizeofCalculator.getSizeAndAlignment(this.fArgument.getType());
                return info == null ? IntegralValue.UNKNOWN : IntegralValue.create(info.alignment);
            }
            case 17: {
                if (arg.isConstantExpression()) {
                    return IntegralValue.create(true);
                }
                return IntegralValue.create(arg.isNoexcept());
            }
            case 16: {
                IValue opVal = this.fArgument.getValue();
                return IntegralValue.create(opVal.numberOfSubValues());
            }
            case 13: {
                return IntegralValue.UNKNOWN;
            }
            case 12: {
                return IntegralValue.UNKNOWN;
            }
        }
        IValue val = arg.getValue();
        if (val == null) {
            return IntegralValue.UNKNOWN;
        }
        return ValueFactory.evaluateUnaryExpression(this.fOperator, val, this.getType());
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        ICPPFunction overload = this.getOverload();
        if (overload != null) {
            return ExpressionTypes.valueCategoryFromFunctionCall(overload);
        }
        switch (this.fOperator) {
            case 0: 
            case 1: 
            case 4: 
            case 13: {
                return IASTExpression.ValueCategory.LVALUE;
            }
            case 11: {
                return this.fArgument.getValueCategory();
            }
        }
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)15);
        buffer.putByte((byte)this.fOperator);
        buffer.marshalEvaluation(this.fArgument, includeValue);
        buffer.marshalBinding(this.fAddressOfQualifiedNameBinding);
        this.marshalTemplateDefinition(buffer);
    }

    public static ICPPEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        int op = buffer.getByte();
        ICPPEvaluation arg = buffer.unmarshalEvaluation();
        IBinding binding = buffer.unmarshalBinding();
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalUnary(op, arg, binding, templateDefinition);
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        if (this.fOperator == 19 && context.getPackOffset() != -1) {
            return new EvalFixed(this.getType(), IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(context.getPackOffset()));
        }
        ICPPEvaluation argument = this.fArgument.instantiate(context, maxDepth);
        IBinding binding = this.fAddressOfQualifiedNameBinding;
        if (binding instanceof ICPPUnknownBinding) {
            try {
                binding = CPPTemplates.resolveUnknown((ICPPUnknownBinding)binding, context);
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        if (argument == this.fArgument && binding == this.fAddressOfQualifiedNameBinding) {
            return this;
        }
        if (binding instanceof IProblemBinding) {
            return EvalFixed.INCOMPLETE;
        }
        return new EvalUnary(this.fOperator, argument, binding, this.getTemplateDefinition());
    }

    private ICPPEvaluation createOperatorOverloadEvaluation(ICPPFunction overload, ICPPEvaluation arg) {
        IBinding templateDefinition = this.getTemplateDefinition();
        if (overload instanceof ICPPMethod) {
            EvalMemberAccess opAccess = new EvalMemberAccess(arg.getType(), IASTExpression.ValueCategory.LVALUE, (IBinding)overload, arg, false, templateDefinition);
            ICPPEvaluation[] args = new ICPPEvaluation[]{opAccess};
            return new EvalFunctionCall(args, arg, templateDefinition);
        }
        EvalBinding op = new EvalBinding((IBinding)overload, (IType)overload.getType(), templateDefinition);
        ICPPEvaluation[] args = new ICPPEvaluation[]{op, arg};
        return new EvalFunctionCall(args, null, templateDefinition);
    }

    private static boolean isModifyingOperation(int op) {
        return op == 0 || op == 1 || op == 9 || op == 10;
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        EvalUnary evalUnary;
        ICPPFunction overload = this.getOverload();
        if (overload != null) {
            ICPPEvaluation operatorCall = this.createOperatorOverloadEvaluation(overload, this.fArgument);
            ICPPEvaluation eval = operatorCall.computeForFunctionCall(record, context);
            return eval;
        }
        EvalUtil.Pair<ICPPEvaluation, ICPPEvaluation> vp = EvalUtil.getValuePair(this.fArgument, record, context);
        ICPPEvaluation updateable = vp.getFirst();
        ICPPEvaluation fixed = vp.getSecond();
        EvalUnary evalUnary2 = evalUnary = fixed == this.fArgument || fixed == EvalFixed.INCOMPLETE ? this : new EvalUnary(this.fOperator, fixed, this.fAddressOfQualifiedNameBinding, this.getTemplateDefinition());
        if (this.fOperator == 4) {
            if (fixed instanceof EvalPointer) {
                EvalPointer evalPointer = (EvalPointer)fixed;
                return evalPointer.dereference();
            }
            if (updateable instanceof EvalBinding && this.isStarOperatorOnArrayName(context)) {
                EvalBinding evalBinding = (EvalBinding)updateable;
                IBinding binding = evalBinding.getBinding();
                ICPPEvaluation eval = record.getVariable(binding);
                if (eval == null) {
                    return EvalFixed.INCOMPLETE;
                }
                EvalCompositeAccess compositeAccess = new EvalCompositeAccess(eval, 0);
                return new EvalReference(record, compositeAccess, this.getTemplateDefinition());
            }
            return evalUnary;
        }
        if (this.fOperator == 5) {
            if (updateable instanceof EvalBinding) {
                EvalBinding evalBinding = (EvalBinding)updateable;
                IBinding binding = evalBinding.getBinding();
                return new EvalPointer(record, binding, this.getTemplateDefinition());
            }
            if (updateable instanceof EvalReference) {
                EvalReference evalRef = (EvalReference)updateable;
                return EvalPointer.createFromAddress(evalRef);
            }
            return evalUnary;
        }
        if (this.fOperator == 11) {
            return updateable != null ? updateable : fixed;
        }
        if (EvalUnary.isModifyingOperation(this.fOperator)) {
            if (fixed instanceof EvalPointer) {
                EvalPointer evalPointer = (EvalPointer)fixed;
                this.applyPointerArithmetics(evalPointer);
                return evalPointer;
            }
            EvalFixed newValue = new EvalFixed(evalUnary.getType(), evalUnary.getValueCategory(), evalUnary.getValue());
            if (updateable instanceof EvalReference) {
                EvalReference evalRef = (EvalReference)updateable;
                evalRef.update(newValue);
            } else if (updateable instanceof EvalCompositeAccess) {
                EvalCompositeAccess evalCompAccess = (EvalCompositeAccess)updateable;
                evalCompAccess.update(newValue);
            } else if (updateable instanceof EvalBinding) {
                EvalBinding evalBinding = (EvalBinding)updateable;
                IBinding binding = evalBinding.getBinding();
                record.update(binding, newValue);
            }
            if (this.getValueCategory() == IASTExpression.ValueCategory.LVALUE) {
                return updateable;
            }
            return fixed;
        }
        return evalUnary;
    }

    private boolean isStarOperatorOnArrayName(ICPPEvaluation.ConstexprEvaluationContext context) {
        return this.fOperator == 4 && this.fArgument.getType() instanceof IArrayType;
    }

    private void applyPointerArithmetics(EvalPointer poiner) {
        switch (this.fOperator) {
            case 0: 
            case 9: {
                poiner.setPosition(poiner.getPosition() + 1);
                break;
            }
            case 1: 
            case 10: {
                poiner.setPosition(poiner.getPosition() - 1);
            }
        }
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        if (this.fOperator == 19) {
            ICPPEvaluation instantiatedArg = this.fArgument.instantiate(new InstantiationContext(tpMap), 25);
            IValue value = instantiatedArg.getValue();
            if (value.numberValue() != null) {
                return (int)value.numberValue().longValue();
            }
            return -1;
        }
        return this.fArgument.determinePackSize(tpMap);
    }

    @Override
    public boolean referencesTemplateParameter() {
        return this.fArgument.referencesTemplateParameter();
    }

    @Override
    public boolean isNoexcept() {
        if (this.fOperator == 12) {
            return false;
        }
        ICPPFunction overload = this.getOverload();
        if (overload != null && !EvalUtil.evaluateNoexceptSpecifier(overload.getType().getNoexceptSpecifier())) {
            return false;
        }
        return this.fArgument.isNoexcept();
    }
}

