/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.local.nio;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.filesystem.local.NativeHandler;

public class DefaultHandler
extends NativeHandler {
    private static final int ATTRIBUTES = 102;

    @Override
    public FileInfo fetchFileInfo(String fileName) {
        Path path = Paths.get(fileName, new String[0]);
        FileInfo info = new FileInfo();
        boolean exists = Files.exists(path, new LinkOption[0]);
        info.setExists(exists);
        try {
            BasicFileAttributes readAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            if (readAttributes.isSymbolicLink()) {
                info.setAttribute(32, true);
                try {
                    info.setStringAttribute(64, Files.readSymbolicLink(path).toString());
                }
                catch (IOException e) {
                    info.setError(5);
                }
            }
            info.setName(path.toFile().getName());
            if (!exists) {
                return info;
            }
            info.setLastModified(readAttributes.lastModifiedTime().toMillis());
            info.setLength(readAttributes.size());
            info.setDirectory(readAttributes.isDirectory());
            info.setAttribute(2, !Files.isWritable(path) && Files.isReadable(path));
            info.setAttribute(4, Files.isExecutable(path));
        }
        catch (IOException e) {
            info.setError(5);
        }
        return info;
    }

    @Override
    public int getSupportedAttributes() {
        return 102;
    }

    @Override
    public boolean putFileInfo(String fileName, IFileInfo info, int options) {
        File file = new File(fileName);
        if (info.getAttribute(2) ? !file.setReadOnly() : !file.setWritable(true)) {
            return false;
        }
        return file.setExecutable(info.getAttribute(4));
    }
}

