/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swtchart.ICircularSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.extensions.barcharts.IBarSeriesSettings;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.InChartLegendUI;
import org.eclipse.swtchart.extensions.core.MappingsDialog;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.core.SeriesListUI;
import org.eclipse.swtchart.extensions.core.SeriesMapper;
import org.eclipse.swtchart.extensions.dialogs.AbstractSeriesSettingsDialog;
import org.eclipse.swtchart.extensions.dialogs.BarSeriesSettingsDialog;
import org.eclipse.swtchart.extensions.dialogs.CircularSeriesSettingsDialog;
import org.eclipse.swtchart.extensions.dialogs.LineSeriesSettingsDialog;
import org.eclipse.swtchart.extensions.dialogs.ScatterSeriesSettingsDialog;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.menu.legend.MapSettingsAction;
import org.eclipse.swtchart.extensions.menu.legend.SeriesVisibilityAction;
import org.eclipse.swtchart.extensions.menu.legend.SetColorAction;
import org.eclipse.swtchart.extensions.menu.legend.SetDescriptionAction;
import org.eclipse.swtchart.extensions.piecharts.CircularSeriesLegend;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesSettings;
import org.eclipse.swtchart.extensions.preferences.PreferencePage;
import org.eclipse.swtchart.extensions.scattercharts.IScatterSeriesSettings;
import org.eclipse.swtchart.model.Node;
import org.eclipse.swtchart.model.NodeDataModel;

public class ExtendedLegendUI
extends Composite {
    private static final String MENU_TEXT = "Series PopUp Menu";
    private AtomicReference<Button> sortControl = new AtomicReference();
    private AtomicReference<InChartLegendUI> toolbarInChartLegend = new AtomicReference();
    private AtomicReference<SeriesListUI> listControl = new AtomicReference();
    private ScrollableChart scrollableChart;
    private ISeriesSet seriesSet;
    private IPreferenceStore preferenceStore = ResourceSupport.getPreferenceStore();

    public ExtendedLegendUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void setScrollableChart(ScrollableChart scrollableChart) {
        this.scrollableChart = scrollableChart;
        this.toolbarInChartLegend.get().setScrollableChart(scrollableChart);
        this.listControl.get().setBaseChart(scrollableChart.getBaseChart());
    }

    public void setInput(ISeriesSet seriesSet) {
        this.seriesSet = seriesSet;
        this.updateSeriesList();
    }

    private void createControl() {
        this.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(this);
        this.createToolbarInChartLegend(this);
        this.createListSection(this);
        this.initialize();
    }

    private void initialize() {
        this.setCompositeVisibility(this.toolbarInChartLegend.get(), false);
        this.updateControls();
        this.applySettings();
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(6, false));
        this.createButtonToggleVisibility(composite);
        this.createButtonToggleLegend(composite);
        this.createButtonToggleSort(composite);
        this.createButtonTransferMappings(composite);
        this.createButtonShowMappings(composite);
        this.createButtonSettings(composite);
    }

    private void createToolbarInChartLegend(Composite parent) {
        InChartLegendUI inChartLegendUI = new InChartLegendUI(parent, 0);
        inChartLegendUI.setLayoutData(new GridData(768));
        this.toolbarInChartLegend.set(inChartLegendUI);
    }

    private Button createButtonToggleVisibility(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Toggle visibility.");
        button.setImage(this.getVisibilityIcon(true));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseChart baseChart = ExtendedLegendUI.this.scrollableChart.getBaseChart();
                boolean visible = ExtendedLegendUI.this.anyVisible(ExtendedLegendUI.this.seriesSet);
                ISeries[] iSeriesArray = ExtendedLegendUI.this.seriesSet.getSeries();
                int n = iSeriesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ISeries series = iSeriesArray[n2];
                    ISeriesSettings seriesSettings = baseChart.getSeriesSettings(series.getId());
                    boolean selection = !visible;
                    seriesSettings.setVisible(selection);
                    seriesSettings.setVisibleInLegend(selection);
                    ExtendedLegendUI.this.applySettings(baseChart, series, seriesSettings, false);
                    ++n2;
                }
                ExtendedLegendUI.this.scrollableChart.redraw();
                button.setImage(ExtendedLegendUI.this.getVisibilityIcon(!visible));
                ExtendedLegendUI.this.listControl.get().refresh();
            }
        });
        return button;
    }

    private boolean anyVisible(ISeriesSet seriesSet) {
        ISeries[] iSeriesArray = seriesSet.getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            if (series.isVisible() || series.isVisibleInLegend()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Image getVisibilityIcon(boolean visible) {
        return visible ? ResourceSupport.getImage("uncheckAll.gif") : ResourceSupport.getImage("checkAll.gif");
    }

    private Button createButtonToggleLegend(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Toggle the visibility of the embedded legend.");
        button.setImage(ResourceSupport.getImage("legend.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExtendedLegendUI.this.isCircularSeries()) {
                    IChartSettings chartSettings;
                    chartSettings.setLegendVisible(!(chartSettings = ExtendedLegendUI.this.scrollableChart.getChartSettings()).isLegendVisible());
                    ExtendedLegendUI.this.scrollableChart.applySettings(chartSettings);
                } else {
                    InChartLegendUI inChartLegendUI = ExtendedLegendUI.this.toolbarInChartLegend.get();
                    ExtendedLegendUI.this.setCompositeVisibility(inChartLegendUI, inChartLegendUI.toggleLegend());
                }
            }
        });
        return button;
    }

    private void createButtonToggleSort(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Sort the table.");
        button.setImage(this.getSortedIcon(this.preferenceStore.getBoolean("sortLegendTable")));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean sorted = ExtendedLegendUI.this.preferenceStore.getBoolean("sortLegendTable");
                ExtendedLegendUI.this.preferenceStore.setValue("sortLegendTable", !sorted);
                ResourceSupport.savePreferenceStore();
                ExtendedLegendUI.this.updateButtonSortImage();
                ExtendedLegendUI.this.updateSeriesTableSortStatus();
            }
        });
        this.sortControl.set(button);
    }

    private Image getSortedIcon(boolean sorted) {
        return sorted ? ResourceSupport.getImage("sort.gif") : ResourceSupport.getImage("sort_disabled.gif");
    }

    private Button createButtonTransferMappings(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Transfer the mappings of the selected series.");
        button.setImage(ResourceSupport.getImage("transfer.png"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openQuestion((Shell)e.display.getActiveShell(), (String)"Mappings", (String)"Would you like to map all listed series?") && ExtendedLegendUI.this.seriesSet != null) {
                    BaseChart baseChart = ExtendedLegendUI.this.scrollableChart.getBaseChart();
                    ISeries[] iSeriesArray = ExtendedLegendUI.this.seriesSet.getSeries();
                    int n = iSeriesArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ISeries series = iSeriesArray[n2];
                        SeriesMapper.map(series, baseChart);
                        ++n2;
                    }
                }
            }
        });
        return button;
    }

    private Button createButtonShowMappings(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Display the mappings.");
        button.setImage(ResourceSupport.getImage("mappings.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingsDialog mappingsDialog = new MappingsDialog(e.display.getActiveShell());
                int returnCode = mappingsDialog.open();
                if (returnCode == 0) {
                    SeriesMapper.update(ExtendedLegendUI.this.scrollableChart.getBaseChart());
                    ExtendedLegendUI.this.updateSeriesList();
                }
            }
        });
        return button;
    }

    private Button createButtonSettings(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Open the settings page.");
        button.setImage(ResourceSupport.getImage("preferences.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePage()));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedLegendUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the settings.");
                    }
                }
            }
        });
        return button;
    }

    private void applySettings() {
        this.updateButtonSortImage();
        this.updateSeriesTableSortStatus();
        this.toolbarInChartLegend.get().update();
    }

    private void createListSection(Composite parent) {
        final SeriesListUI seriesListUI = new SeriesListUI(parent, 68354);
        seriesListUI.setTableSortable(this.preferenceStore.getBoolean("sortLegendTable"));
        Table table = seriesListUI.getTable();
        table.setLayoutData((Object)new GridData(1808));
        String menuId = ((Object)((Object)this)).getClass().getCanonicalName();
        MenuManager menuManager = new MenuManager(MENU_TEXT, menuId);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)new SeriesVisibilityAction(seriesListUI, false, false));
        menuManager.addMenuListener((IMenuListener)new SeriesVisibilityAction(seriesListUI, true, false));
        menuManager.addMenuListener((IMenuListener)new SeriesVisibilityAction(seriesListUI, false, true));
        menuManager.addMenuListener((IMenuListener)new SeriesVisibilityAction(seriesListUI, true, true));
        menuManager.addMenuListener((IMenuListener)new SetColorAction(seriesListUI));
        menuManager.addMenuListener((IMenuListener)new SetDescriptionAction(seriesListUI));
        menuManager.addMenuListener((IMenuListener)new MapSettingsAction(seriesListUI, true));
        menuManager.addMenuListener((IMenuListener)new MapSettingsAction(seriesListUI, false));
        Menu menu = menuManager.createContextMenu((Control)table);
        table.setMenu(menu);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object object = seriesListUI.getStructuredSelection().getFirstElement();
                if (object instanceof ISeries) {
                    ISeries series = (ISeries)object;
                    BaseChart baseChart = ExtendedLegendUI.this.scrollableChart.getBaseChart();
                    ISeriesSettings seriesSettings = baseChart.getSeriesSettings(series.getId());
                    Shell shell = e.display.getActiveShell();
                    AbstractSeriesSettingsDialog settingsDialog = null;
                    if (seriesSettings instanceof IBarSeriesSettings) {
                        IBarSeriesSettings settings = (IBarSeriesSettings)seriesSettings;
                        settingsDialog = new BarSeriesSettingsDialog(shell, settings);
                    } else if (seriesSettings instanceof ICircularSeriesSettings) {
                        ICircularSeriesSettings settings = (ICircularSeriesSettings)seriesSettings;
                        settingsDialog = new CircularSeriesSettingsDialog(shell, settings);
                    } else if (seriesSettings instanceof ILineSeriesSettings) {
                        ILineSeriesSettings settings = (ILineSeriesSettings)seriesSettings;
                        settingsDialog = new LineSeriesSettingsDialog(shell, settings);
                    } else if (seriesSettings instanceof IScatterSeriesSettings) {
                        IScatterSeriesSettings settings = (IScatterSeriesSettings)seriesSettings;
                        settingsDialog = new ScatterSeriesSettingsDialog(shell, settings);
                    }
                    if (settingsDialog != null && settingsDialog.open() == 0) {
                        ExtendedLegendUI.this.applySettings(baseChart, series, seriesSettings, true);
                    }
                }
            }
        });
        this.listControl.set(seriesListUI);
    }

    private void updateControls() {
        this.updateButtonSortImage();
        this.toolbarInChartLegend.get().update();
    }

    private void updateButtonSortImage() {
        this.sortControl.get().setImage(this.getSortedIcon(this.preferenceStore.getBoolean("sortLegendTable")));
    }

    private void updateSeriesTableSortStatus() {
        SeriesListUI seriesListUI = this.listControl.get();
        seriesListUI.setTableSortable(this.preferenceStore.getBoolean("sortLegendTable"));
        seriesListUI.getTable().redraw();
    }

    private void applySettings(BaseChart baseChart, ISeries<?> series, ISeriesSettings seriesSettingsSource, boolean refresh) {
        baseChart.applySeriesSettings(series, seriesSettingsSource, true);
        if (refresh) {
            baseChart.redraw();
            this.listControl.get().refresh();
        }
    }

    private void updateSeriesList() {
        if (this.seriesSet != null) {
            ICircularSeries<?> circularSeries = this.getCircularSeries();
            if (circularSeries != null) {
                this.listControl.get().setInput(this.getCalculatedCircularSeries(circularSeries));
            } else {
                this.listControl.get().setInput(this.seriesSet);
            }
        } else {
            this.listControl.get().clear();
        }
    }

    private List<ISeries<?>> getCalculatedCircularSeries(ICircularSeries<?> circularSeries) {
        NodeDataModel nodeDataModel;
        ArrayList seriesList = new ArrayList();
        String[] labels = circularSeries.getLabels();
        if (labels != null && (nodeDataModel = circularSeries.getNodeDataModel()) != null) {
            String[] stringArray = labels;
            int n = labels.length;
            int n2 = 0;
            while (n2 < n) {
                String label = stringArray[n2];
                Node node = nodeDataModel.getNodeById(label);
                if (node != null) {
                    seriesList.add((ISeries<?>)new CircularSeriesLegend(node, nodeDataModel));
                }
                ++n2;
            }
        }
        return seriesList;
    }

    private ICircularSeries<?> getCircularSeries() {
        ISeries series;
        ICircularSeries circularSeries = null;
        if (this.seriesSet != null && this.seriesSet.getSeries().length > 0 && (series = this.seriesSet.getSeries()[0]) instanceof ICircularSeries) {
            circularSeries = (ICircularSeries)series;
        }
        return circularSeries;
    }

    private boolean isCircularSeries() {
        return this.getCircularSeries() != null;
    }

    private void setCompositeVisibility(Composite composite, boolean visible) {
        if (composite != null) {
            composite.setVisible(visible);
            Object layoutData = composite.getLayoutData();
            if (layoutData instanceof GridData) {
                GridData gridData = (GridData)layoutData;
                gridData.exclude = !visible;
            }
            Composite parent = composite.getParent();
            parent.layout(true);
            parent.redraw();
        }
    }
}

