/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.flamechart;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.profiling.core.base.IProfilingGroupDescriptor;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackSeries;
import org.eclipse.tracecompass.analysis.profiling.core.tests.CallStackTestBase;
import org.eclipse.tracecompass.analysis.profiling.core.tests.data.CallStackTestData;
import org.eclipse.tracecompass.analysis.profiling.core.tests.data.TestDataBigCallStack;
import org.eclipse.tracecompass.analysis.profiling.core.tests.data.TestDataSmallCallStack;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs.CallStackAnalysisStub;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.InstrumentedGroupDescriptor;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.tests.shared.utils.IntervalInfo;
import org.eclipse.tracecompass.statesystem.core.tests.shared.utils.StateSystemTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CallStackStateSystemTest
extends CallStackTestBase {
    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({"Small trace", new TestDataSmallCallStack()}, {"Big trace", new TestDataBigCallStack()});
    }

    public CallStackStateSystemTest(String name, CallStackTestData data) {
        super(data);
    }

    @Test
    public void testCallStackProvider() {
        CallStackAnalysisStub module = this.getModule();
        Assert.assertNotNull((Object)((Object)module));
        CallStackSeries callstack = module.getCallStackSeries();
        Assert.assertNotNull((Object)callstack);
        List<String[]> patterns = module.getPatterns();
        Assert.assertEquals((long)2L, (long)patterns.size());
        IProfilingGroupDescriptor nextLevel = callstack.getRootGroup();
        Assert.assertTrue((boolean)(nextLevel instanceof InstrumentedGroupDescriptor));
        Object[] subPattern = ((InstrumentedGroupDescriptor)nextLevel).getSubPattern();
        Assert.assertArrayEquals((Object[])patterns.get(0), (Object[])subPattern);
        nextLevel = nextLevel.getNextGroup();
        Assert.assertTrue((boolean)(nextLevel instanceof InstrumentedGroupDescriptor));
        subPattern = ((InstrumentedGroupDescriptor)nextLevel).getSubPattern();
        Assert.assertArrayEquals((Object[])patterns.get(1), (Object[])subPattern);
        nextLevel = nextLevel.getNextGroup();
        Assert.assertNull((Object)nextLevel);
    }

    @Test
    public void testCallStackContent() throws AttributeNotFoundException {
        CallStackAnalysisStub module = this.getModule();
        Assert.assertNotNull((Object)((Object)module));
        CallStackSeries callstack = module.getCallStackSeries();
        Assert.assertNotNull((Object)callstack);
        ITmfStateSystem ss = module.getStateSystem();
        Assert.assertNotNull((Object)ss);
        List<String[]> patterns = module.getPatterns();
        CallStackTestData traceData = this.getTraceData();
        List quarks = ss.getQuarks(patterns.get(0));
        Assert.assertEquals((String)"Number of processes", (long)traceData.getNumberOfProcesses(), (long)quarks.size());
        int actualStackCount = 0;
        for (Integer processQuark : quarks) {
            List threadQuarks = ss.getQuarks(processQuark.intValue(), patterns.get(1));
            Assert.assertEquals((String)"Number of processes", (long)2L, (long)threadQuarks.size());
            for (Integer threadQuark : threadQuarks) {
                int csQuark = ss.getQuarkRelative(threadQuark.intValue(), new String[]{"CallStack"});
                List subAttributes = ss.getSubAttributes(csQuark, false);
                actualStackCount += subAttributes.size();
            }
        }
        Set<@NonNull IntervalInfo> stateSystemIntervals = traceData.toStateSystemInterval(patterns.get(0)[0]);
        Assert.assertEquals((String)"Number of callstack data elements", (long)stateSystemIntervals.size(), (long)actualStackCount);
        StateSystemTestUtils.testIntervals((ITmfStateSystem)ss, stateSystemIntervals);
    }
}

