/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.expressions;

import java.text.MessageFormat;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.actions.TextViewerAction;

public class WatchExpressionDialog
extends StatusDialog {
    private final IWatchExpression fWatchExpression;
    private SourceViewer fSnippetViewer;
    private Button fCheckBox;
    private Label fTip;

    public WatchExpressionDialog(Shell parent, IWatchExpression watchExpression, boolean editDialog) {
        super(parent);
        this.fWatchExpression = watchExpression;
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        String helpContextId = null;
        if (editDialog) {
            this.setTitle(ActionMessages.WatchExpressionDialog_0);
            helpContextId = "org.eclipse.debug.ui.edit_watch_expression_dialog_context";
        } else {
            this.setTitle(ActionMessages.WatchExpressionDialog_1);
            helpContextId = "org.eclipse.debug.ui.add_watch_expression_dialog_context";
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, helpContextId);
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        Label label = new Label(container, 0);
        label.setText(ActionMessages.WatchExpressionDialog_2);
        gd = new GridData(1);
        label.setLayoutData((Object)gd);
        label.setFont(font);
        this.fSnippetViewer = new SourceViewer(container, null, 0x2000B00);
        this.fSnippetViewer.setInput((Object)this);
        Document document = new Document();
        this.fSnippetViewer.configure(new SourceViewerConfiguration());
        this.fSnippetViewer.setEditable(true);
        this.fSnippetViewer.setDocument((IDocument)document);
        document.addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                WatchExpressionDialog.this.checkValues();
            }
        });
        this.fSnippetViewer.getTextWidget().setFont(JFaceResources.getTextFont());
        Control control = this.fSnippetViewer.getControl();
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        control.setLayoutData((Object)gd);
        this.fSnippetViewer.getDocument().set(this.fWatchExpression.getExpressionText());
        TextViewerAction cutAction = new TextViewerAction((ITextViewer)this.fSnippetViewer, 3);
        cutAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_CUT"));
        cutAction.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        cutAction.setText(ActionMessages.WatchExpressionDialogMenu_0);
        TextViewerAction copyAction = new TextViewerAction((ITextViewer)this.fSnippetViewer, 4);
        copyAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        copyAction.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        copyAction.setText(ActionMessages.WatchExpressionDialogMenu_1);
        TextViewerAction pasteAction = new TextViewerAction((ITextViewer)this.fSnippetViewer, 5);
        pasteAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        pasteAction.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        pasteAction.setText(ActionMessages.WatchExpressionDialogMenu_2);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)cutAction);
        menuManager.add((IAction)copyAction);
        menuManager.add((IAction)pasteAction);
        menuManager.addMenuListener(manager -> {
            cutAction.update();
            copyAction.update();
            pasteAction.update();
        });
        Menu menu = menuManager.createContextMenu((Control)this.fSnippetViewer.getTextWidget());
        this.fSnippetViewer.getTextWidget().setMenu(menu);
        this.fCheckBox = new Button(container, 16416);
        this.fCheckBox.setText(ActionMessages.WatchExpressionDialog_3);
        this.fCheckBox.setSelection(this.fWatchExpression.isEnabled());
        this.fCheckBox.setFont(font);
        String tipText = MessageFormat.format(ActionMessages.WatchExpressionDialog_5, this.getCtrlReturnText());
        this.fTip = new Label(container, 16384);
        this.fTip.setText(tipText);
        this.fTip.setFont(font);
        WatchExpressionDialog.applyDialogFont((Control)container);
        this.fSnippetViewer.getControl().setFocus();
        return container;
    }

    private String getCtrlReturnText() {
        IKeyLookup keyLookup = KeyLookupFactory.getDefault();
        int ctrlKey = keyLookup.getCtrl();
        int returnKey = keyLookup.formalKeyLookup("RETURN");
        KeyStroke ctrlReturnKeyStroke = KeyStroke.getInstance((int)ctrlKey, (int)returnKey);
        KeySequence ctrltReturnKeySequence = KeySequence.getInstance((KeyStroke)ctrlReturnKeyStroke);
        return SWTKeySupport.getKeyFormatterForPlatform().format(ctrltReturnKeySequence);
    }

    protected void okPressed() {
        this.fWatchExpression.setEnabled(this.fCheckBox.getSelection());
        this.fWatchExpression.setExpressionText(this.fSnippetViewer.getDocument().get());
        super.okPressed();
    }

    private void checkValues() {
        StatusInfo status = new StatusInfo();
        if (this.fSnippetViewer.getDocument().get().trim().length() == 0) {
            status.setError(ActionMessages.WatchExpressionDialog_4);
        }
        this.updateStatus(status);
    }
}

