/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.statevalue;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

final class NullStateValue
extends TmfStateValue {
    public static final TmfStateValue INSTANCE = new NullStateValue();
    private static final String VALUE = "nullValue";

    private NullStateValue() {
    }

    @Override
    public ITmfStateValue.Type getType() {
        return ITmfStateValue.Type.NULL;
    }

    @Override
    public boolean isNull() {
        return true;
    }

    public boolean equals(@Nullable Object object) {
        return object instanceof NullStateValue;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return VALUE;
    }

    @Override
    public int unboxInt() {
        return -1;
    }

    @Override
    public long unboxLong() {
        return -1L;
    }

    @Override
    public double unboxDouble() {
        return Double.NaN;
    }

    @Override
    public String unboxStr() {
        return VALUE;
    }

    @Override
    public int compareTo(@Nullable ITmfStateValue other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        if (other instanceof NullStateValue) {
            return 0;
        }
        int result = Math.max(-100, Math.min(100, other.compareTo(this)));
        return -result;
    }

    @Override
    public @Nullable Object unboxValue() {
        return null;
    }
}

