/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.struct;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.CTFAntlrMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMemberMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeAliasParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeDeclaratorParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class StructDeclarationParser
extends AbstractScopedCommonTreeParser {
    public static final StructDeclarationParser INSTANCE = new StructDeclarationParser();

    private StructDeclarationParser() {
    }

    @Override
    public StructDeclaration parse(ICTFMetadataNode declaration, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        DeclarationScope scope = ((Param)param).fDeclarationScope;
        StructDeclaration struct = ((Param)param).fStruct;
        CTFTrace trace = ((Param)param).fTrace;
        StringBuilder identifierSB = new StringBuilder();
        IDeclaration decl = null;
        String fieldName = null;
        boolean isCtf1 = declaration instanceof CTFAntlrMetadataNode;
        if (isCtf1) {
            ICTFMetadataNode typeSpecifierListNode = declaration.getFirstChildWithType(CTFParser.tokenNames[117]);
            if (typeSpecifierListNode == null) {
                throw new ParseException("Cannot have a struct without a type specifier");
            }
            ICTFMetadataNode typeDeclaratorListNode = declaration.getFirstChildWithType(CTFParser.tokenNames[116]);
            if (typeDeclaratorListNode == null) {
                throw new ParseException("Cannot have a struct without a declarator");
            }
            List<ICTFMetadataNode> typeDeclaratorList = typeDeclaratorListNode.getChildren();
            for (ICTFMetadataNode typeDeclaratorNode : typeDeclaratorList) {
                decl = TypeDeclaratorParser.INSTANCE.parse(typeDeclaratorNode, new TypeDeclaratorParser.Param(trace, typeSpecifierListNode, scope, identifierSB));
            }
            fieldName = identifierSB.toString();
            if (struct.getField(fieldName) != null) {
                throw new ParseException("struct: duplicate field " + fieldName);
            }
        } else {
            decl = TypeAliasParser.INSTANCE.parse(declaration, new TypeAliasParser.Param(trace, scope));
            fieldName = ((JsonStructureFieldMemberMetadataNode)declaration).getName();
            if (fieldName == null) {
                fieldName = ((JsonStructureFieldMemberMetadataNode)declaration).getRole();
            }
        }
        if (decl == null) {
            throw new ParseException("struct: Cannot add null field " + fieldName);
        }
        scope.registerIdentifier(fieldName, decl);
        IDeclaration current = struct.getField(fieldName);
        if (current != null && !Objects.equal((Object)decl, (Object)current)) {
            throw new ParseException("struct: duplicate field " + fieldName);
        }
        if (fieldName != null) {
            struct.addField(fieldName, decl);
        }
        return struct;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final StructDeclaration fStruct;
        private final DeclarationScope fDeclarationScope;
        private final CTFTrace fTrace;

        public Param(StructDeclaration struct, CTFTrace trace, DeclarationScope scope) {
            this.fStruct = struct;
            this.fTrace = trace;
            this.fDeclarationScope = scope;
        }
    }
}

