/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.packet;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.packet.Packet;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.ethernet2.EthernetIIPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class PacketTest {
    private ByteBuffer fEthernetPacket;

    @Before
    public void initialize() {
        this.fEthernetPacket = ByteBuffer.allocate(15);
        this.fEthernetPacket.order(ByteOrder.BIG_ENDIAN);
        this.fEthernetPacket.put((byte)52);
        this.fEthernetPacket.put((byte)103);
        this.fEthernetPacket.put((byte)12);
        this.fEthernetPacket.put((byte)-46);
        this.fEthernetPacket.put((byte)-111);
        this.fEthernetPacket.put((byte)81);
        this.fEthernetPacket.put((byte)16);
        this.fEthernetPacket.put((byte)-8);
        this.fEthernetPacket.put((byte)-126);
        this.fEthernetPacket.put((byte)-77);
        this.fEthernetPacket.put((byte)68);
        this.fEthernetPacket.put((byte)120);
        this.fEthernetPacket.put((byte)-94);
        this.fEthernetPacket.put((byte)86);
        this.fEthernetPacket.put((byte)-90);
        this.fEthernetPacket.flip();
    }

    @Test
    public void GenericPacketTest() throws BadPacketException, IOException, BadPcapFileException {
        PcapTestTrace trace = PcapTestTrace.MOSTLY_TCP;
        Assume.assumeTrue((boolean)trace.exists());
        Throwable throwable = null;
        Object var3_4 = null;
        try (PcapFile dummy = trace.getTrace();){
            ByteBuffer byteBuffer = this.fEthernetPacket;
            if (byteBuffer == null) {
                Assert.fail((String)"GenericPacketTest has failed!");
                return;
            }
            EthernetIIPacket packet = new EthernetIIPacket(dummy, null, byteBuffer);
            Assert.assertTrue((boolean)packet.hasProtocol(PcapProtocol.ETHERNET_II));
            Assert.assertTrue((boolean)packet.hasProtocol(PcapProtocol.UNKNOWN));
            Assert.assertFalse((boolean)packet.hasProtocol(PcapProtocol.TCP));
            Assert.assertEquals((Object)PcapProtocol.ETHERNET_II, (Object)packet.getProtocol());
            Assert.assertEquals((Object)packet, (Object)packet.getPacket(PcapProtocol.ETHERNET_II));
            Assert.assertNull((Object)packet.getPacket(PcapProtocol.TCP));
            Assert.assertEquals((Object)packet.getChildPacket(), (Object)packet.getPacket(PcapProtocol.UNKNOWN));
            Assert.assertEquals((Object)packet.getPacket(PcapProtocol.ETHERNET_II), (Object)packet.getMostEcapsulatedPacket());
            Assert.assertNull((Object)packet.getParentPacket());
            Assert.assertFalse((boolean)packet.getPcapFile().equals(null));
            Packet child = packet.getChildPacket();
            if (child == null) {
                Assert.fail((String)"GenericPacketTest has failed!");
                return;
            }
            Assert.assertEquals((Object)packet.getPayload(), (Object)child.getPayload());
            Assert.assertEquals((Object)packet.getGlobalSummaryString(), (Object)"Source MAC: 10:f8:82:b3:44:78 , Destination MAC: 34:67:0c:d2:91:51");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

