/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.model.xy.ISeriesModel;
import org.eclipse.tracecompass.tmf.core.model.xy.TmfXYAxisDescription;

public class SeriesModel
implements ISeriesModel {
    private static final String DEFAULT_XAXIS_NAME = "X Axis";
    private static final String DEFAULT_XAXIS_UNIT = "";
    private static final String DEFAULT_YAXIS_NAME = "Y Axis";
    private static final String DEFAULT_YAXIS_UNIT = "";
    @SerializedName(value="id")
    private final transient long fId;
    @SerializedName(value="name")
    private final String fName;
    @SerializedName(value="xValues")
    private final long[] fXValues;
    @SerializedName(value="yValues")
    private final double[] fYValues;
    @SerializedName(value="xAxis")
    private final TmfXYAxisDescription fXAxis;
    @SerializedName(value="yAxis")
    private final TmfXYAxisDescription fYAxis;
    @SerializedName(value="dataType")
    private final ISeriesModel.DisplayType fDisplayType;
    @SerializedName(value="properties")
    private final int[] fProperties;

    public SeriesModel(long id, String name, long[] xValues, double[] yValues) {
        this(id, name, xValues, yValues, new TmfXYAxisDescription(DEFAULT_XAXIS_NAME, ""), new TmfXYAxisDescription(DEFAULT_YAXIS_NAME, ""), ISeriesModel.DisplayType.LINE, new int[xValues.length]);
    }

    private SeriesModel(long id, String name, long[] xValues, double[] yValues, TmfXYAxisDescription xAxis, TmfXYAxisDescription yAxis, ISeriesModel.DisplayType displayType, int[] properties) {
        this.fId = id;
        this.fName = name;
        this.fXValues = xValues;
        this.fYValues = yValues;
        this.fXAxis = xAxis;
        this.fYAxis = yAxis;
        this.fDisplayType = displayType;
        this.fProperties = properties;
    }

    @Override
    public long getId() {
        return this.fId;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public TmfXYAxisDescription getXAxisDescription() {
        return this.fXAxis;
    }

    @Override
    public TmfXYAxisDescription getYAxisDescription() {
        return this.fYAxis;
    }

    @Override
    public ISeriesModel.DisplayType getDisplayType() {
        return this.fDisplayType;
    }

    @Override
    public long[] getXAxis() {
        return this.fXValues;
    }

    @Override
    public double[] getData() {
        return this.fYValues;
    }

    @Override
    public int[] getProperties() {
        return this.fProperties;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SeriesModel other = (SeriesModel)obj;
        return this.fName.equals(other.getName()) && this.fId == other.getId() && Arrays.equals(this.fXValues, other.getXAxis()) && Arrays.equals(this.fYValues, other.getData()) && this.fXAxis.equals(other.getXAxisDescription()) && this.fYAxis.equals(other.getYAxisDescription());
    }

    public int hashCode() {
        return Objects.hash(this.fId, this.fName, this.fXValues, this.fYValues, this.fXAxis, this.fYAxis);
    }

    public static class SeriesModelBuilder {
        private final long id;
        private final String name;
        private final long[] xValues;
        private final double[] yValues;
        private @Nullable TmfXYAxisDescription xAxis;
        private @Nullable TmfXYAxisDescription yAxis;
        private @Nullable ISeriesModel.DisplayType displayType;
        private int @Nullable [] properties;

        public SeriesModelBuilder(long id, String name, long[] xValues, double[] yValues) {
            this.id = id;
            this.name = name;
            this.xValues = xValues;
            this.yValues = yValues;
        }

        public SeriesModelBuilder xAxisDescription(TmfXYAxisDescription axis) {
            this.xAxis = axis;
            return this;
        }

        public SeriesModelBuilder yAxisDescription(TmfXYAxisDescription axis) {
            this.yAxis = axis;
            return this;
        }

        public SeriesModelBuilder seriesDisplayType(ISeriesModel.DisplayType type) {
            this.displayType = type;
            return this;
        }

        public SeriesModelBuilder setProperties(int[] properties) {
            this.properties = properties;
            return this;
        }

        public SeriesModel build() {
            return new SeriesModel(this.id, this.name, this.xValues, this.yValues, this.xAxis != null ? this.xAxis : new TmfXYAxisDescription(SeriesModel.DEFAULT_XAXIS_NAME, ""), this.yAxis != null ? this.yAxis : new TmfXYAxisDescription(SeriesModel.DEFAULT_YAXIS_NAME, ""), this.displayType != null ? this.displayType : ISeriesModel.DisplayType.LINE, this.properties != null ? this.properties : new int[this.xValues.length]);
        }
    }
}

