/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.comment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.comment.BlockCommentingStrategy;
import org.eclipse.wst.sse.ui.internal.comment.CommentingStrategy;
import org.eclipse.wst.sse.ui.internal.comment.LineCommentingStrategy;

public class CommentingStrategyRegistry {
    private static final String EXTENSION_POINT = "commentingStrategy";
    private static final String ELEM_PROPOSAL_BLOCK_COMMENTING_STRATEGY = "blockCommentingStrategy";
    private static final String ELEM_PROPOSAL_LINE_COMMENTING_STRATEGY = "lineCommentingStrategy";
    private static final String ELEM_CONTENT_TYPE = "contentType";
    private static final String ELEM_REQUIRED_PARTITION_TYPES = "requiredPartitionTypes";
    private static final String ELEM_ALLOWABLE_PARTITION_TYPES = "allowablePartitionTypes";
    private static final String ELEM_PARTITION_TYPE = "partitionType";
    private static final String ATTR_PREFIX = "prefix";
    private static final String ATTR_SUFFIX = "suffix";
    private static final String ATTR_ASSOCIATED_COMMENT_PARTITION_TPYPE_ID = "associatedCommentPartitionTypeID";
    private static final String ATTR_ANY_PARTITION_TYPE = "anyPartitionType";
    private static final String ATTR_ID = "id";
    private static CommentingStrategyRegistry fSingleton = null;
    private boolean fLoaded = false;
    private Map fBlockCommentTypes = new HashMap();
    private Map fLineCommentTypes = new HashMap();

    public static synchronized CommentingStrategyRegistry getDefault() {
        if (fSingleton == null) {
            fSingleton = new CommentingStrategyRegistry();
        }
        return fSingleton;
    }

    private CommentingStrategyRegistry() {
    }

    public CommentingStrategy getBlockCommentingStrategy(String contentTypeID, ITypedRegion[] regions) {
        return this.getCommentingStrategy(contentTypeID, regions, this.fBlockCommentTypes);
    }

    public CommentingStrategy getLineCommentingStrategy(String contentTypeID, ITypedRegion[] regions) {
        return this.getCommentingStrategy(contentTypeID, regions, this.fLineCommentTypes);
    }

    private CommentingStrategy getCommentingStrategy(String contentTypeID, ITypedRegion[] regions, Map registry) {
        this.ensureExtensionPointRead();
        CommentingStrategy match = null;
        IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeID);
        ArrayList possibleCommentingStrategies = new ArrayList();
        while (contentType != null) {
            List contentTypeCommentingStrategies = (List)registry.get(contentType.getId());
            if (contentTypeCommentingStrategies != null && contentTypeCommentingStrategies.size() > 0) {
                possibleCommentingStrategies.addAll(contentTypeCommentingStrategies);
            }
            contentType = contentType.getBaseType();
        }
        int i = 0;
        while (i < possibleCommentingStrategies.size() && match == null) {
            CommentingStrategy commentType = (CommentingStrategy)possibleCommentingStrategies.get(i);
            if (commentType.isApplicableFor(regions)) {
                match = commentType;
            }
            ++i;
        }
        return match;
    }

    private void ensureExtensionPointRead() {
        if (!this.fLoaded) {
            this.load();
            this.fLoaded = true;
        }
    }

    private void load() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> extensionElements = new ArrayList<IConfigurationElement>(Arrays.asList(extensionRegistry.getConfigurationElementsFor("org.eclipse.wst.sse.ui", EXTENSION_POINT)));
        for (IConfigurationElement element : extensionElements) {
            try {
                String prefix;
                CommentingStrategy newCommentingStrategy = null;
                Map commentingStrategyRegistry = null;
                if (element.getName().equals(ELEM_PROPOSAL_BLOCK_COMMENTING_STRATEGY)) {
                    prefix = element.getAttribute(ATTR_PREFIX);
                    CommentingStrategyRegistry.checkExtensionAttributeNotNull(prefix, ATTR_PREFIX, element);
                    String suffix = element.getAttribute(ATTR_SUFFIX);
                    CommentingStrategyRegistry.checkExtensionAttributeNotNull(suffix, ATTR_SUFFIX, element);
                    if (prefix != null && suffix != null) {
                        newCommentingStrategy = new BlockCommentingStrategy(prefix, suffix);
                        commentingStrategyRegistry = this.fBlockCommentTypes;
                    }
                } else if (element.getName().equals(ELEM_PROPOSAL_LINE_COMMENTING_STRATEGY)) {
                    prefix = element.getAttribute(ATTR_PREFIX);
                    CommentingStrategyRegistry.checkExtensionAttributeNotNull(prefix, ATTR_PREFIX, element);
                    if (prefix != null) {
                        newCommentingStrategy = new LineCommentingStrategy(prefix);
                        commentingStrategyRegistry = this.fLineCommentTypes;
                    }
                }
                if (commentingStrategyRegistry != null && newCommentingStrategy != null) {
                    CommentingStrategyRegistry.addCommentingStrategyToRegistry(element, commentingStrategyRegistry, newCommentingStrategy);
                    continue;
                }
                Logger.log(2, "Invalid CommentingStrategy extension: " + element);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
            catch (InvalidRegistryObjectException x) {
                String message = "The extension ''" + element.toString() + "'' is invalid.";
                Status status = new Status(2, "org.eclipse.wst.sse.ui", 2, message, (Throwable)x);
                Logger.log((IStatus)status);
            }
        }
    }

    private static void checkExtensionAttributeNotNull(Object value, String attribute, IConfigurationElement element) throws InvalidRegistryObjectException, CoreException {
        if (value == null) {
            String message = "The extension \"" + element.getDeclaringExtension().getUniqueIdentifier() + "\" from plug-in \"" + element.getContributor().getName() + "\" did not specify a value for the required \"" + attribute + "\" attribute for the element \"" + element.getName() + "\". Disabling the extension.";
            Status status = new Status(2, "org.eclipse.wst.sse.ui", 0, message, null);
            throw new CoreException((IStatus)status);
        }
    }

    private static void addCommentingStrategyToRegistry(IConfigurationElement element, Map commentingStrategyRegistry, CommentingStrategy baseCommentingStrategy) {
        IConfigurationElement[] contentTypeElements = element.getChildren(ELEM_CONTENT_TYPE);
        if (contentTypeElements.length > 0) {
            int contentTypeIndex = 0;
            while (contentTypeIndex < contentTypeElements.length) {
                try {
                    String contentTypeID = contentTypeElements[contentTypeIndex].getAttribute(ATTR_ID);
                    CommentingStrategyRegistry.checkExtensionAttributeNotNull(contentTypeID, ATTR_ID, contentTypeElements[contentTypeIndex]);
                    ArrayList<CommentingStrategy> commentTypes = (ArrayList<CommentingStrategy>)commentingStrategyRegistry.get(contentTypeID);
                    if (commentTypes == null) {
                        commentTypes = new ArrayList<CommentingStrategy>();
                        commentingStrategyRegistry.put(contentTypeID, commentTypes);
                    }
                    ArrayList<String> allowablePartitionTypeIDs = new ArrayList<String>();
                    IConfigurationElement[] allowablePartitionTypes = contentTypeElements[contentTypeIndex].getChildren(ELEM_ALLOWABLE_PARTITION_TYPES);
                    boolean anyPartitionType = false;
                    String anyPartitionTypeValue = allowablePartitionTypes[0].getAttribute(ATTR_ANY_PARTITION_TYPE);
                    if (anyPartitionTypeValue != null) {
                        anyPartitionType = Boolean.valueOf(anyPartitionTypeValue);
                    }
                    if ((allowablePartitionTypes = allowablePartitionTypes[0].getChildren(ELEM_PARTITION_TYPE)).length > 0) {
                        int partitionTypeIndex = 0;
                        while (partitionTypeIndex < allowablePartitionTypes.length) {
                            String partitionTypeID = allowablePartitionTypes[partitionTypeIndex].getAttribute(ATTR_ID);
                            CommentingStrategyRegistry.checkExtensionAttributeNotNull(partitionTypeID, ATTR_ID, allowablePartitionTypes[partitionTypeIndex]);
                            allowablePartitionTypeIDs.add(partitionTypeID);
                            ++partitionTypeIndex;
                        }
                    }
                    ArrayList<String> requiredPartitionTypeIDs = new ArrayList<String>();
                    IConfigurationElement[] requiredPartitionTypes = contentTypeElements[contentTypeIndex].getChildren(ELEM_REQUIRED_PARTITION_TYPES);
                    if (requiredPartitionTypes.length > 0 && (requiredPartitionTypes = requiredPartitionTypes[0].getChildren(ELEM_PARTITION_TYPE)).length > 0) {
                        int partitionTypeIndex = 0;
                        while (partitionTypeIndex < requiredPartitionTypes.length) {
                            String partitionTypeID = requiredPartitionTypes[partitionTypeIndex].getAttribute(ATTR_ID);
                            CommentingStrategyRegistry.checkExtensionAttributeNotNull(partitionTypeID, ATTR_ID, requiredPartitionTypes[partitionTypeIndex]);
                            requiredPartitionTypeIDs.add(partitionTypeID);
                            ++partitionTypeIndex;
                        }
                    }
                    String associatedCommentPartitionTypeID = contentTypeElements[contentTypeIndex].getAttribute(ATTR_ASSOCIATED_COMMENT_PARTITION_TPYPE_ID);
                    CommentingStrategy newCommentingStrategy = (CommentingStrategy)baseCommentingStrategy.clone();
                    newCommentingStrategy.setPartitionInformation(allowablePartitionTypeIDs, anyPartitionType, requiredPartitionTypeIDs, associatedCommentPartitionTypeID);
                    commentTypes.add(newCommentingStrategy);
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
                ++contentTypeIndex;
            }
        } else {
            Logger.log(2, "The commmenting strategy element: " + element + " does not contain any required " + ELEM_CONTENT_TYPE + "s");
        }
    }
}

